/*
	This program demonstrates that all of the methods of the
	class Fraction work properly
*/

public class FractionTester {

	public static void main(String args[]) {
		System.out.println("Fraction Tester");
		System.out.println();
		
		/* These were the basic tests from the first version */
		
		System.out.println ("Demo of current constructors & accessors ");
		System.out.println();
		
		Fraction f1 = new Fraction (7,3);
		System.out.println ("f1 is a fraction with " +
					f1.getNumerator() + " as numerator and " +
					f1.getDenominator() + " as denominator");
		System.out.println ("f1 = " + f1 + " = " + f1.getDecimalValue());
		System.out.println();
		
		Fraction f2 = new Fraction (4);
		System.out.println ("f2 = " + f2 + " = " + f2.getDecimalValue());
		System.out.println();

		Fraction f3 = new Fraction ();
		System.out.println ("f3 = " + f3 + " = " + f3.getDecimalValue());
		System.out.println();
		
		System.out.println("Attempting to create a bad fraction (-52/0)");
		Fraction f4 = new Fraction (-52,0);
		System.out.println ("f4 = " + f4 + " = " + f4.getDecimalValue());
		System.out.println();		

		System.out.println ("Demo of current mutators ");
		System.out.println();
		System.out.println("Changing f1's numerator to 6");
		f1.setNumerator(6);
		System.out.println ("f1 = " + f1 + " = " + f1.getDecimalValue());
		System.out.println();
		
		System.out.println("Changing f2's denominator to 5");
		f2.setDenominator(5);
		System.out.println ("f2 = " + f2 + " = " + f2.getDecimalValue());		
		System.out.println();
		
		System.out.println("Attempting to change f2's denominator to 0");
		f2.setDenominator(0);
		System.out.println ("f2 = " + f2 + " = " + f2.getDecimalValue());
		
		System.out.println ("Objects created so far " + Fraction.getObjectsCreated());
		
		// New tests for Monday's added methods
		System.out.println();
		System.out.println("Equality tests");
		Fraction f5 = new Fraction (12,32);
		Fraction f6 = new Fraction (15,40);
		System.out.println ("f5 = " + f5 + " = " + f5.getDecimalValue());
		System.out.println ("f6 = " + f6 + " = " + f6.getDecimalValue());
		if ( f5.equals(f6) )
			System.out.println("Both f5 and f6 represent the same fraction.");
		else
			System.out.println ("f5 and f6 represent different fractions");
		if ( f5.equals(f2) )
			System.out.println("Both f5 and f2 represent the same fraction.");
		else
			System.out.println ("f5 and f2 represent different fractions");
			
		System.out.println();
		System.out.println("Lowest terms testing");
		System.out.println ("f5 = " + f5 + " = " + f5.getDecimalValue());
		System.out.println("Applying 'changeToLowestTerms' to f5");
		f5.changeToLowestTerms();
		System.out.println ("f5 = " + f5 + " = " + f5.getDecimalValue());

		System.out.println();
		System.out.println("using toLowestTerms on f6 to produce f7");
		Fraction f7 = Fraction.toLowestTerms(f6);
		System.out.println ("f7 = " + f7 + " = " + f7.getDecimalValue());
		System.out.println ("f6 = " + f6 + " = " + f6.getDecimalValue());
		
		System.out.println ("Objects created so far " + Fraction.getObjectsCreated());
		
	}
}
