/*
	This is the beginnings of a class that represents fractions

*/

public class Fraction {


	// instance variables	
	private int numerator;
	private int denominator = 1;
	


	/* *************************************************** *
			Constructors
	 * *************************************************** */
	public Fraction (int num, int denom) {
	// the most general constructor
		numerator = num;
		if (denom != 0)
			denominator = denom;
		else
			System.out.println("Sorry, you can't create a fraction with a denominator of zero");
	}
	
	public Fraction (int num) {
	// if one parameter is provided, the constructor
	// creates the fraction num / 1
		this (num, 1);
	}
	
	public Fraction () {
	// default constructor that produces 1 / 1
		this (1,1);
	}
	
	
	/* *************************************************** *
			Accessors
	 * *************************************************** */
	public int getNumerator(){
		return numerator;
	}
	
	public int getDenominator(){
		return denominator;
	}
		
	public double getDecimalValue() {
		return (double) numerator / denominator;
	}
	
	public String toString () {
		return numerator + "/" + denominator;
	}

	
	/* *************************************************** *
			Mutators
	 * *************************************************** */
	 
	public void setNumerator ( int toValue) {
		numerator = toValue;
	}

	public void setDenominator ( int toValue) {
		if (toValue != 0)
			denominator = toValue;
		else
			System.out.println("Sorry, you can't change a denominator to zero");
	}	

	

}