/*
	This program demonstrates 
	a) basic usage of a primitive array (here, an array of ints)
	b) the use of a string tokenizer (over a file of ints)
	
*/
import java.util.*;
public class PrimitiveArrayDemo {

	public static final int MAX_CAPACITY = 100;
	// when allocating a primitive array, one must
	// specify a capacity
	
	public static TextInput kb = new TextInput();

	public static void main(String args[]) {
		System.out.println("Hello World!");
		
		int [] myArray = new int[MAX_CAPACITY];
		int myArraySize = 0;
		// Since the entire physical capacity of an array
		// is generally not fully used, we need to create 
		// an auxillary int variable representing the array's
		// logical size.
		// If the array is called arr, then I call the variable
		// arrSize. The variable tells me
		//   a) how many elements are in the array
		//   b) the index of the first location that is not used
		//      (as long as the size is less than the capacity)
		
		
		// You can always get the physical capacity of an array by using
		// myArray.length:
		
		// System.out.println("The capacity of the array is " + myArray.length);
		
				
		
		TextInput source = getFile ("What file of ints do you want to load? ");

		while (!source.atEndOfFile()) {
		
			// This worked if we assumed that there is only one int per line:
			
			// int num = source.readInt();
			// myArray[myArraySize++] = num;
			
			// However to allow files of ints with more than one int per line,
			// we use a StringTokenizer coupled with the parseInt method
			
			String line = source.readLine();
			
			StringTokenizer st = new StringTokenizer(line);
			
			while (st.hasMoreTokens() ) {

				String value = st.nextToken();
			
				int num = Integer.parseInt(value);
			
				myArray[myArraySize++] = num;

			}
		}
		
			
		// display the array contents
		int i;
		for (i = 0; i < myArraySize/*myArray.length*/ ; i++) {
			System.out.println("myArray["+i+"] = " + myArray[i] );
		}
		
		
		// These generate the run-time exception ArrayIndexOutOfBoundsException
		
		// System.out.println ("What's this: " + myArray[MAX_CAPACITY]);		
		// System.out.println("Here's a number : " + myArray[-1]);
		
	}
	
	public static TextInput getFile (String prompt) {
	// a method we've used in the past
	// This method continually prompts the typist for the name of a
	// file. This doesn't guarentee that the file is formatted correctly.
		System.out.print(prompt+" ");
		String fName = kb.readLine();
		TextInput src = new TextInput(fName);
		while (!src.isValidSource()) {
			System.out.println ("Sorry, the file doesn't exist or you don't have read privileges");
			System.out.println ("Choose another file");
			System.out.print(prompt+" ");
			fName = kb.readLine();
			src = new TextInput(fName);		
		}	
		return src;
	}
}
