﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GOTCHA_Challenge
{
    public partial class Create_Account : Form
    {
        public Create_Account()
        {
            InitializeComponent();
        }
        /// <summary>
        /// Display the Inkblot images that correspond with the user's password
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button2_Click(object sender, EventArgs e)
        {
            int password = 0;
            bool parseRes = int.TryParse(txtPassword.Text, out password);
            if (!parseRes) MessageBox.Show("Password Must Be a Number");
            Bitmap[] puzzles = GOTCHA_Challenge.generatePuzzles(password);
            pictureBox1.Image = puzzles[0];
            pictureBox2.Image = puzzles[1];
            pictureBox3.Image = puzzles[2];
            pictureBox4.Image = puzzles[3];
            pictureBox5.Image = puzzles[4];
            pictureBox6.Image = puzzles[5];
            pictureBox7.Image = puzzles[6];
            pictureBox8.Image = puzzles[7];
            pictureBox9.Image = puzzles[8];
            pictureBox10.Image = puzzles[9];
        }
        /// <summary>
        /// Generates the password file. Based on the user's password, the user's labels
        /// and a random permuation. 
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click(object sender, EventArgs e)
        {
            string [] labels = new string[10]{textBox1.Text, textBox2.Text, textBox3.Text, textBox4.Text, textBox5.Text, textBox6.Text, textBox7.Text, textBox8.Text, textBox9.Text,textBox10.Text};
            int password = 0;
            bool parseRes = int.TryParse(txtPassword.Text, out password);
            if (!parseRes) MessageBox.Show("Password Must Be a Number");
            richTextBox1.Text =  GOTCHA_Challenge.storePassword(password,labels);
        }
        /// <summary>
        /// Make the picture bigger when the cursor hovers over it
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pictureBox1_MouseEnter(object sender, EventArgs e)
        {
            PictureBox theOrigin = (PictureBox)sender;
            theOrigin.Width *= 3;
            theOrigin.Height *= 3;
            theOrigin.BringToFront();
        }
        /// <summary>
        /// Make the picture normal sized when the cursor leaves it
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pictureBox1_MouseLeave(object sender, EventArgs e)
        {
            PictureBox theOrigin = (PictureBox)sender;
            theOrigin.Width /= 3;
            theOrigin.Height /= 3;
        }

        private void Create_Account_Load(object sender, EventArgs e)
        {

        }

        private void button3_Click(object sender, EventArgs e)
        {
            string filename = textBox11.Text + "Inkblot";
            pictureBox1.Image.Save(filename + "1.jpg");
            pictureBox2.Image.Save(filename + "2.jpg");
            pictureBox3.Image.Save(filename + "3.jpg");
            pictureBox4.Image.Save(filename + "4.jpg");
            pictureBox5.Image.Save(filename + "5.jpg");
            pictureBox6.Image.Save(filename + "6.jpg");
            pictureBox7.Image.Save(filename + "7.jpg");
            pictureBox8.Image.Save(filename + "8.jpg");
            pictureBox9.Image.Save(filename + "9.jpg");
            pictureBox10.Image.Save(filename + "10.jpg");
        }
    }
}
