﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GOTCHA_Challenge
{
    public partial class Authenticate : Form
    {
        public Authenticate()
        {
            InitializeComponent();
        }

        string passwordRecord = "";
        /// <summary>
        /// Display the Inkblots that correspond with 
        /// the password the user has entered.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button2_Click(object sender, EventArgs e)
        {
            int password = 0;
            bool parseRes = int.TryParse(textBox1.Text,out password);
            if (!parseRes) { MessageBox.Show("Password Must Be a Number"); return; }
            Bitmap[] puzzles = GOTCHA_Challenge.generatePuzzles(password);
            pictureBox1.Image = puzzles[0];
            pictureBox2.Image = puzzles[1];
            pictureBox3.Image = puzzles[2];
            pictureBox4.Image = puzzles[3];
            pictureBox5.Image = puzzles[4];
            pictureBox6.Image = puzzles[5];
            pictureBox7.Image = puzzles[6];
            pictureBox8.Image = puzzles[7];
            pictureBox9.Image = puzzles[8];
            pictureBox10.Image = puzzles[9];
        }
        /// <summary>
        /// Check to see if the password the user entered
        /// is correct. To do this we must first recover
        /// the permutation from the user's matching.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click(object sender, EventArgs e)
        {
            int password = 0;
            bool parseRes = int.TryParse(textBox1.Text,out password);
            if (!parseRes) { MessageBox.Show("Password Must Be a Number"); return; }
            int [] selIndexes = new int[10];
            int[] permute = new int[10];
            selIndexes[0] = comboBox1.SelectedIndex ;
            selIndexes[1] = comboBox2.SelectedIndex ;
            selIndexes[2] = comboBox3.SelectedIndex ;
            selIndexes[3] = comboBox4.SelectedIndex ;
            selIndexes[4] = comboBox5.SelectedIndex ;
            selIndexes[5] = comboBox6.SelectedIndex ;
            selIndexes[6] = comboBox7.SelectedIndex ;
            selIndexes[7] = comboBox8.SelectedIndex ;
            selIndexes[8] = comboBox9.SelectedIndex ;
            selIndexes[9] = comboBox10.SelectedIndex ;
            for (int i = 0; i < 10; i++)
            {
                for (int j = i+1; j < 10; j++)
                {
                    if (selIndexes[i] == selIndexes[j])
                        MessageBox.Show("Image " + (i+1) + "and Image " + (j+1) +"have the same selection");
                   // return;
                }

            }
            for (int i = 0; i < 10; i++)
            {
                if (selIndexes[i] < 0)
                {
                    MessageBox.Show("Please Complete the Matching");
                    return;
                }
                permute[selIndexes[i]] = i;
            }
            string passwordHash = passwordRecord.Split(new char[] {'\r', '\n' },StringSplitOptions.RemoveEmptyEntries)[0];
            if (GOTCHA_Challenge.verifyPassword(password, permute, passwordHash))
            {
                MessageBox.Show("Correct!");
            }
            else
            {
                MessageBox.Show("Incorrect");
            }


        }

        /// <summary>
        /// Updates the ComboBoxes to the labels which
        /// correspond to the selected account.
        /// </summary>
        /// <param name="sender">comboBox11 --- Account Selection</param>
        /// <param name="e"></param>
        private void comboBox11_SelectedIndexChanged(object sender, EventArgs e)
        {
            comboBox1.Items.Clear();
            comboBox2.Items.Clear();
            comboBox3.Items.Clear();
            comboBox4.Items.Clear();
            comboBox5.Items.Clear();
            comboBox6.Items.Clear();
            comboBox7.Items.Clear();
            comboBox8.Items.Clear();
            comboBox9.Items.Clear();
            comboBox10.Items.Clear();
            switch (comboBox11.SelectedIndex) {
                case 0:
                    passwordRecord = PasswordFile.Account0;
                    break;
                case 1:
                    passwordRecord = PasswordFile.Account1;
                    break;
                case 2:
                    passwordRecord = PasswordFile.Account2;
                    break;
                case 3:
                    passwordRecord = PasswordFile.Account3;
                    break;
               case 4:
                    passwordRecord = PasswordFile.Account4;
                    break;
               case 5:
                    passwordRecord = PasswordFile.Account5;
                    break;
               case 6:
                    passwordRecord = PasswordFile.Account6;
                    break;
               case 7:
                    passwordRecord = PasswordFile.Account7;
                    break;
               case 8:
                    passwordRecord = PasswordFile.Account8;
                    break;
               case 9:
                    passwordRecord = PasswordFile.Account9;
                    break;
               case 10:
                    passwordRecord = PasswordFile.Account10;
                    break;
                default: break;
            }
            string[] labels = new string[10];
            string[] splitRes = passwordRecord.Split(new char[] { '\n' });
            for (int i = 0; i < labels.Length; i++)
            {
                labels[i] = splitRes[i + 1];
                comboBox1.Items.Add(labels[i]);
                comboBox2.Items.Add(labels[i]);
                comboBox3.Items.Add(labels[i]);
                comboBox4.Items.Add(labels[i]);
                comboBox5.Items.Add(labels[i]);
                comboBox6.Items.Add(labels[i]);
                comboBox7.Items.Add(labels[i]);
                comboBox8.Items.Add(labels[i]);
                comboBox9.Items.Add(labels[i]);
                comboBox10.Items.Add(labels[i]);
            }
        }

        /// <summary>
        /// Make the picture bigger when the cursor hovers over it
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pictureBox_MouseEnter(object sender, EventArgs e)
        {
            PictureBox theOrigin = (PictureBox)sender;
            theOrigin.Width *= 3;
            theOrigin.Height *= 3;
            theOrigin.BringToFront();
        }
        /// <summary>
        /// Make the picture normal sized when the cursor leaves it
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void pictureBox_MouseLeave(object sender, EventArgs e)
        {
            PictureBox theOrigin = (PictureBox)sender;
            theOrigin.Width /= 3;
            theOrigin.Height /= 3;
        }
    }
}
