-- Author: Mario Dehesa Azuara (mdehazu@gmail.com)

open import Data.Nat using (ℕ)
open import Data.Product using (_×_;_,_)
open import Data.String using (String)

open import Relation.Binary.PropositionalEquality
       using (_≡_;refl)

module Syntax where
    Var : Set
    Var = String
    open import Data.String using (_≟_;decSetoid) public

    data FID : Set where
        fid : Var → FID

    data Tp : Set where
            bool : Tp
            list : ℕ → Tp → Tp

    FTp : Set
    FTp = Tp × ℕ × ℕ × Tp

    data Oper : Set where
            var   : Oper
            true  : Oper
            false : Oper
            if₁   : Oper
            if₂   : Oper
            elet  : Oper
            nil   : Oper
            cons  : Oper
            matl₁ : Oper
            matl₂ : Oper
            app   : Oper

    data Exp : Set where
            var : Var → Exp

            true : Exp
            false : Exp
            if : Var → Exp → Exp → Exp

            elet : Exp → (Var × Exp) → Exp

            nil : Exp
            cons : Var → Var → Exp
            matl : Var → Exp → (Var × Var × Exp) → Exp

            share : Var → (Var × Var × Exp) → Exp

            app : FID → Var → Exp

    Sig : Set
    Sig = FID → FTp × Var × Exp

    data Val : Set where
            true : Val
            false : Val
            nil : Val
            cons : Val → Val → Val

    cons-eq : ∀ {v x xs y ys : Val}
              → v ≡ cons x xs
              → v ≡ cons y ys
              → (x ≡ y × xs ≡ ys)
    cons-eq refl refl = refl , refl
