-- Author Mario Dehesa Azuara (mdehazu@gmail.com)

open import Syntax
open import Environment
open import Context

open import Data.Nat using (ℕ)

open import Data.Empty using (⊥-elim;⊥)
open import Relation.Binary.PropositionalEquality
       using (_≡_;refl;subst₂;sym;cong-app;trans)

module Preservation(metric : Oper → ℕ)(Δ : Sig) where
        open import BigStep metric Δ
        open import Statics metric Δ


        nil-cons-lemma : ∀ {e v vs : Val} → e ≡ nil → e ≡ cons v vs → ⊥
        nil-cons-lemma refl ()

        preservation : ∀ {Γ : Ctx}{Ω : Env}{E : Exp}{T : Tp}{V : Val}{q q' p p' : ℕ}
                       → Γ ⊢ E ∶ T ↓〈 p , p' 〉
                       → Ω ⊢ E ⇓ V ∣〈 q , q' 〉
                       → EnvOK Ω Γ
                       → SigOK Δ
                       → ValOK V T
        preservation (of/var v T q₁ p' x)
                     (step/var Ω .v V q q' x₁)
                     (ok/cons eq vok ok/nil) _ =
          let
            H : ValOK (Ω v) T
            H = subst₂ ValOK (sym eq) refl vok
          in subst₂ ValOK (sym (proj₂ V)) refl H
        preservation (of/true _ _ _) (step/true _ _ _ _) _ _ = vok/tt
        preservation (of/false _ _ _) (step/false _ _ _ _) _ _ = vok/ff
        preservation (of/if _ _ _ _ _ _ _ _ _ _ _ DS _ DS₁)
                     (step/if₁ _ _ _ _ _ _ _ _ _ DE _)
                     (ok/cons _ _ ok) sok = preservation DS DE ok sok
        preservation (of/if _ _ _ _ _ _ _ _ _ _ _ _ _ DS₁)
                     (step/if₂ _ _ _ _ _ _ _ _ _ DE _)
                     (ok/cons _ _ ok) sok = preservation DS₁ DE ok sok
        preservation (of/let Γ₁ Γ₂ _ _ v T₁ T₂ _ _ _ _ frsh DS _ DS₁)
                     (step/let Ω _ _ .v V₁ V₂ _ _ _ _ DE Ω' DE₁ _)
                     ok sok =
          let
            H₀ : ValOK V₁ T₁
            H₀ = preservation DS DE (ok-append₁ Γ₁ Γ₂ ok) sok

            H₁ : EnvOK (v , V₁ ∣ Ω) Γ₂
            H₁ = ok-extend Γ₂ v (ok-append₂ Γ₁ Γ₂ ok) (fresh-++₂ v Γ₁ Γ₂ frsh)

            H₂ : (proj₁ Ω') v ≡ V₁
            H₂ = trans (cong-app (proj₂ Ω') v) (env-extend v)

            H₃ : EnvOK (proj₁ Ω') ((v , T₁) ∷ Γ₂)
            H₃ = ok/cons H₂ H₀ (subst₂ EnvOK (sym (proj₂ Ω')) refl H₁)
          in preservation DS₁ DE₁ H₃ sok
        preservation (of/nil _ _ _ _ _) (step/nil _ _ _ _) _ _ = vok/nil
        preservation (of/cons v₁ v₂ T p _ _ _)
                     (step/cons Ω .v₁ .v₂ _ _ _ V VS)
                     (ok/cons eq vok (ok/cons eq₁ vok₁ ok)) _ =
          let
            H₀ : ValOK (proj₁ V) T
            H₀ = subst₂ ValOK (sym (proj₂ V)) refl (subst₂ ValOK (sym eq) refl vok)

            H₁ : ValOK (proj₁ VS) (list p T)
            H₁ = subst₂ ValOK (sym (proj₂ VS)) refl (subst₂ ValOK (sym eq₁) refl vok₁)
          in vok/cons (proj₁ V) (proj₁ VS) H₀ H₁
        preservation (of/matl Γ v v₁ v₂ E₁ E₂ T T' _ _ _ _ _ x x₁ x₂ x₃ DS x₄ DS₁)
                     (step/matl₁ Ω .v .v₁ .v₂ .E₁ .E₂ V _ _ _ x₅ x₆ DE)
                     (ok/cons eq vok ok) sok = preservation DS DE ok sok
        preservation (of/matl _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ DS _ DS₁)
                     (step/matl₂ _ _ _ _ _ _ _ _ _  _ _ _ eqcons H DE _)
                     (ok/cons eqnil vok/nil ok) _ =
                     ⊥-elim (nil-cons-lemma eqnil eqcons)
        preservation (of/matl Γ v x xs _ _ _ _ _ _ _ _ _ frsh frsh₁ frsh₂ _ DS _ DS₁)
                     (step/matl₂ Ω .v .x .xs E₁ E₂ X XS _ _ _ _ eqcons Ω' DE _)
                     (ok/cons eq (vok/cons y ys vok tvok) ok) sok =
          let
            H₀ : EnvOK (xs , XS ∣ Ω) Γ
            H₀ = ok-extend Γ xs ok (fresh-wkn frsh₂)

            H₁ : EnvOK (x , X ∣ (xs , XS ∣ Ω)) Γ
            H₁ = ok-extend Γ x H₀ (fresh-wkn frsh₁)

            H₂ : EnvOK (proj₁ Ω') Γ
            H₂ = subst₂ EnvOK (sym (proj₂ Ω')) refl H₁

            H₃ : (proj₁ Ω') x ≡ X
            H₃ = trans (cong-app (proj₂ Ω') x) (env-extend x)

            H₄ : (proj₁ Ω') xs ≡ XS
            H₄ = trans (cong-app (proj₂ Ω') xs) (env-extend₂ x xs frsh₂)

            (eqx , eqxs) = cons-eq eqcons eq
          in preservation
               DS₁
               DE
               (ok/cons (trans H₃ eqx) vok (ok/cons (trans H₄ eqxs) tvok H₂))
               sok
        preservation (of/share Γ x x₁ x₂ _ _ _ _ _ _ _ frsh frsh₁ frsh₂ shareok DS)
                     (step/share Ω _ _ _ _ V V₁ _ _ eqv Ω' DE)
                     (ok/cons {v} eq vok ok)
                     sok =
          let
            H₀ : EnvOK (x₂ , V ∣ Ω) Γ
            H₀ = (ok-extend Γ x₂ ok (fresh-wkn frsh₂))

            H₁ : EnvOK (x₁ , V ∣ (x₂ , V ∣ Ω)) Γ
            H₁ = (ok-extend Γ x₁ H₀ (fresh-wkn frsh₁))

            H₂ : EnvOK (proj₁ Ω') Γ
            H₂ = subst₂ EnvOK (sym (proj₂ Ω')) refl H₁

            H₃ : V ≡ v
            H₃ = trans (sym eqv) eq

            H₄ : (proj₁ Ω') x₁ ≡ V
            H₄ = trans (cong-app (proj₂ Ω') x₁) (env-extend x₁)

            H₅ : (proj₁ Ω') x₂ ≡ V
            H₅ = trans (cong-app (proj₂ Ω') x₂) (env-extend₂ x₁ x₂ frsh₂)

          in preservation DS DE
                (ok/cons (trans H₄ H₃)
                         (ok-share₁ shareok vok)
                         (ok/cons (trans H₅ H₃) (ok-share₂ shareok vok) H₂))
                sok
        preservation (of/app _ _ _ _ _ _ _ _ _ refl _)
                     (step/app _ f _ _ _ _ _ _ _ _ _ _ _ _ refl refl _ DE)
                     (ok/cons refl vok ok/nil) sok =
          preservation
            (sok refl)
            DE
            (ok/cons refl
                     (subst₂ ValOK (sym (env-extend (proj₁ (proj₂ (Δ f))))) refl vok)
                     ok/nil)
            sok
        preservation (of/wkn _ _ _ _ _ _ _ _ DS) DE (ok/cons _ _ ok) sok =
          preservation DS DE ok sok
        preservation (of/rlx _ _ _ _ _ _ _ DS _ _) DE ok sok =
          preservation DS DE ok sok
        preservation (of/exg Γ₁ Γ₂ E T q p' DS) DE ok sok =
          preservation DS DE (ok-exg Γ₂ Γ₁ ok) sok
        preservation (of/sub _ _ _ _ _ _ sub DS) DE ok sok =
          ok-sub sub (preservation DS DE ok sok)
        preservation (of/sup _ _ _ _ _ _ _ _ sup DS) DE (ok/cons eq vokh vokt) sok =
          preservation DS DE (ok/cons eq (ok-sub sup vokh) vokt) sok
