-- Author: Mario Dehesa Azuara (mdehazu@gmail.com)
open import Context
open import Syntax

open import Data.Empty using (⊥-elim;⊥)
open import Data.Nat using (ℕ)

open import Relation.Nullary using (yes;no)
open import Relation.Binary.PropositionalEquality using (_≡_;refl;sym;trans)
open import Data.Product using (_×_ ; _,_; proj₁; proj₂) public

module Environment where
    Env = Var → Val

    _,_∣_ : Var → Val → Env → Env
    (x , v ∣ Ω) x' with x ≟ x'
    ... | yes _ = v
    ... | no _ = Ω(x')

    ◎ : Env
    ◎ _ = nil

    env-extend : ∀ (x : Var){V : Val}{Ω : Env} → (x , V ∣ Ω) x ≡ V
    env-extend x with x ≟ x
    ...          | yes _ = refl
    ...          | no ¬p = ⊥-elim (¬p refl)

    env-extend₂ : ∀ (x₁ x₂ : Var){T : Tp}{V₁ V₂ : Val}{Ω : Env}{Γ : Ctx}
                  → fresh x₂ ((x₁ , T) ∷ Γ)
                  → (x₁ , V₁ ∣ (x₂ , V₂ ∣ Ω)) x₂ ≡ V₂
    env-extend₂ x₁ x₂ {T} DF with x₁ ≟ x₂
    ...          | yes p = ⊥-elim (DF T (here ((sym p , refl))))
    ...          | no ¬p = env-extend x₂

    env-extend-neq : ∀ (x v : Var){Ω : Env}{val : Val}
                     → (x ≡ v → ⊥)
                     → (v , val ∣ Ω) x ≡ Ω x
    env-extend-neq x v neq with v ≟ x
    ... | yes p = ⊥-elim (neq (sym p))
    ... | no _ = refl

    data ValOK : Val → Tp → Set where
        vok/tt : ValOK true bool
        vok/ff : ValOK false bool

        vok/nil : ∀{n : ℕ}{T : Tp}
                  → ValOK nil (list n T)

        vok/cons : ∀{n : ℕ}{T : Tp}(v vs : Val)
                 → ValOK v T
                 → ValOK vs (list n T)
                 → ValOK (cons v vs) (list n T)

    vok-cons : ∀ {x v vs : Val}{m : ℕ}{T : Tp}
                 (ok : ValOK x (list m T))
               → x ≡ cons v vs
               → (ValOK v T) × (ValOK vs (list m T))
    vok-cons (vok/cons v vs ok ok₁) refl = (ok , ok₁)

    data EnvOK : Env → Ctx → Set where
        ok/nil : ∀ {Ω : Env} → EnvOK Ω ∅
        ok/cons : ∀ {v : Val}{Ω : Env}{x : Var}{T : Tp}{Γ : Ctx}
                  (eq : (Ω x) ≡ v)
                  (vok : ValOK v T)
                  (ok : EnvOK Ω Γ)
                  → EnvOK Ω ((x , T) ∷ Γ)

    ok-append₁ : ∀ (Γ₁ Γ₂ : Ctx){Ω : Env}
                 → EnvOK Ω (Γ₁ ++ Γ₂)
                 → EnvOK Ω Γ₁
    ok-append₁ ∅ Γ₂ _ = ok/nil
    ok-append₁ (_ ∷ Γ) Γ₂ (ok/cons eq vok ok) =
      ok/cons eq vok (ok-append₁ Γ Γ₂ ok)

    ok-append₂ : ∀ (Γ₁ Γ₂ : Ctx){Ω : Env}
                 → EnvOK Ω (Γ₁ ++ Γ₂)
                 → EnvOK Ω Γ₂
    ok-append₂ ∅ Γ ok = ok
    ok-append₂ (_ ∷ Γ₁) Γ (ok/cons eq vok ok) = ok-append₂ Γ₁ Γ ok

    ok-append : ∀ (Γ₁ Γ₂ : Ctx){Ω : Env}
                → EnvOK Ω Γ₁
                → EnvOK Ω Γ₂
                → EnvOK Ω (Γ₁ ++ Γ₂)
    ok-append ∅ Γ₂ ok₁ ok₂ = ok₂
    ok-append (_ ∷ Γ) Γ₂ (ok/cons eq vok ok) ok₂ =
      ok/cons eq vok (ok-append Γ Γ₂ ok ok₂)

    ok-exg : ∀ (Γ₁ Γ₂ : Ctx){Ω : Env}
             → EnvOK Ω (Γ₁ ++ Γ₂)
             → EnvOK Ω (Γ₂ ++ Γ₁)
    ok-exg Γ₁ Γ₂ ok =
      ok-append Γ₂ Γ₁ (ok-append₂ Γ₁ Γ₂ ok) (ok-append₁ Γ₁ Γ₂ ok)

    ok-extend : ∀ (Γ : Ctx){Ω : Env}(v : Var){val : Val}
                → EnvOK Ω Γ
                → fresh v Γ
                → EnvOK (v , val ∣ Ω) Γ
    ok-extend ∅ v _ _ = ok/nil
    ok-extend ((x , T) ∷ Γ) v (ok/cons eq vok ok) frsh with x ≟ v
    ... | yes p = ⊥-elim (frsh T (here (sym p , refl)))
    ... | no ¬p = ok/cons
                    (trans (env-extend-neq x v ¬p) eq)
                    vok
                    (ok-extend Γ v ok (fresh-wkn frsh))

    import Statics as S

    ok-sub : ∀ {V : Val}{T₁ T₂ : Tp}{metric : Oper → ℕ}{Δ : Sig}
             → S._<∶_ metric Δ T₁ T₂
             → ValOK V T₁
             → ValOK V T₂
    ok-sub S.sub/bool vok/tt = vok/tt
    ok-sub S.sub/bool vok/ff = vok/ff
    ok-sub (S.sub/list x x₁) vok/nil = vok/nil
    ok-sub (S.sub/list sub le) (vok/cons v vs vokh vokt) =
      vok/cons v vs (ok-sub sub vokh) (ok-sub (S.sub/list sub le) vokt)

    ok-share₁ : ∀ {metric : Oper → ℕ}{V : Val}{T T₁ T₂ : Tp}{Δ : Sig}
                → S.ShareOK metric Δ T T₁ T₂
                → ValOK V T
                → ValOK V T₁
    ok-share₁ S.sok/bool vok/tt = vok/tt
    ok-share₁ S.sok/bool vok/ff = vok/ff
    ok-share₁ (S.sok/list T T₁ T₂ eq sok) vok/nil = vok/nil
    ok-share₁ (S.sok/list T T₁ T₂ eq sok) (vok/cons v vs vok vok₁) =
      vok/cons v vs (ok-share₁ sok vok) (ok-share₁ (S.sok/list T T₁ T₂ eq sok) vok₁)

    ok-share₂ : ∀ {metric : Oper → ℕ}{Δ : Sig}{V : Val}{T T₁ T₂ : Tp}
                → S.ShareOK metric Δ T T₁ T₂
                → ValOK V T
                → ValOK V T₂
    ok-share₂ S.sok/bool vok/tt = vok/tt
    ok-share₂ S.sok/bool vok/ff = vok/ff
    ok-share₂ (S.sok/list T T₁ T₂ eq sok) vok/nil = vok/nil
    ok-share₂ {metric}{Δ}
              (S.sok/list {p} {p₁} {p₂} T T₁ T₂ eq sok)
              (vok/cons v vs vok vok₁) =
      vok/cons v vs (ok-share₂ sok vok)
                    (ok-share₂  ((SS.sok/list {p} {p₁} {p₂} T T₁ T₂ eq sok)) vok₁)
       where module SS = S metric Δ
