-- Author: Mario Dehesa Azuara (mdehazu@gmail.com)

open import Syntax
open import Context
open import Relation.Binary.PropositionalEquality using (_≡_)

open import Data.Product using (_,_)
open import Data.List using
        (List; _++_; _∷_) renaming ([] to ∅)
open import Data.Nat


module Statics (metric : Oper → ℕ)(Δ : Sig) where
    data ShareOK : Tp → Tp → Tp → Set where
        sok/bool : ShareOK bool bool bool
        sok/list : ∀ {p p₁ p₂ : ℕ}(T T₁ T₂ : Tp)
                   → p ≡ p₁ + p₂
                   → ShareOK T T₁ T₂
                   → ShareOK (list p T) (list p₁ T₁) (list p₂ T₂)

    data _<∶_ : Tp → Tp → Set where
        sub/bool : bool <∶ bool
        sub/list : ∀ {n₁ n₂ : ℕ}{T₁ T₂ : Tp}
                   → T₁ <∶ T₂
                   → n₁ ≤ n₂
                   → list n₁ T₁ <∶ list n₂ T₂

    data _⊢_∶_↓〈_,_〉 : ∀ (Γ : Ctx)(E : Exp)(T : Tp)(q : ℕ)(q' : ℕ) → Set where
        of/var : ∀ (v : Var)(T : Tp)
                → ((v , T) ∷ ∅) ⊢ var v ∶ T ↓〈 metric var , 0 〉

        of/true : ∅ ⊢ true ∶ bool ↓〈 metric true , 0 〉

        of/false : ∅ ⊢ false ∶ bool ↓〈 metric false , 0 〉

        of/if : ∀ (Γ : Ctx)(x : Var)(E₁ E₂ : Exp)(T : Tp)(q₁ q₂ q q' : ℕ)
                → fresh x Γ
                → q ≡ q₁ + (metric if₁)
                → Γ ⊢ E₁ ∶ T ↓〈 q₁ , q' 〉
                → q ≡ q₂ + (metric if₂)
                → Γ ⊢ E₂ ∶ T ↓〈 q₂ , q' 〉
                → ((x , bool) ∷ Γ) ⊢ if x E₁ E₂ ∶ T ↓〈 q , q' 〉

        of/let : ∀ (Γ₁ Γ₂ : Ctx)(E₁ E₂ : Exp)(v : Var)(T₁ T₂ : Tp)(p p' q q' : ℕ)
                → fresh v (Γ₁ ++ Γ₂)
                → Γ₁ ⊢ E₁ ∶ T₁ ↓〈 p , p' 〉
                → q ≡ p + (metric elet)
                → ((v , T₁) ∷ Γ₂) ⊢ E₂ ∶ T₂ ↓〈 p' , q' 〉
                → (Γ₁ ++ Γ₂) ⊢ elet E₁ (v , E₂) ∶ T₂ ↓〈 q , q' 〉

        of/nil : ∀ (T : Tp)(p : ℕ)
                 → ∅ ⊢ nil ∶ list p T ↓〈 metric nil , 0 〉

        of/cons : ∀ (v vs : Var)(T : Tp)(p : ℕ)
                  → ((v , T) ∷ (vs , list p T) ∷ ∅) ⊢
                        cons v vs ∶ list p T ↓〈 metric cons + p , 0 〉

        of/matl :
              ∀ (Γ : Ctx)(v v₁ v₂ : Var)(E₁ E₂ : Exp)
                (T T' : Tp)(q q' q₁ q₂ p : ℕ)
              → fresh v Γ
              → fresh v₁ ((v₂ , list p T) ∷ Γ)
              → fresh v₂ ((v₁ , T) ∷ Γ)
              → q ≡ q₁ + (metric matl₁)
              → Γ ⊢ E₁ ∶ T' ↓〈 q₁ , q' 〉
              → q + p ≡ q₂ + (metric matl₂)
              → ((v₁ , T) ∷ (v₂ , list p T) ∷  Γ) ⊢ E₂ ∶ T' ↓〈 q₂ , q' 〉
              → ((v , list p T) ∷ Γ) ⊢ (matl v E₁ (v₁ , v₂ , E₂)) ∶ T' ↓〈 q , q' 〉

        of/share : ∀ (Γ : Ctx)(x x₁ x₂ : Var)(E : Exp)(T T₁ T₂ M : Tp)(q q' : ℕ)
                   → fresh x Γ
                   → fresh x₁ ((x₂ , T₂) ∷ Γ)
                   → fresh x₂ ((x₁ , T₁) ∷ Γ)
                   → ShareOK T T₁ T₂
                   → ((x₁ , T₁) ∷ (x₂ , T₂) ∷ Γ) ⊢ E ∶ M ↓〈 q , q' 〉
                   → ((x , T) ∷ Γ) ⊢ share x (x₁ , x₂ , E) ∶ M ↓〈 q , q' 〉

        of/app : ∀ (x x₁ : Var)(T₁ T₂ : Tp)(f : FID)(q q₁ q' : ℕ)(E : Exp)
                 → Δ(f) ≡ ((T₁ , q₁ , q' , T₂), x₁ , E)
                 → q ≡ q₁ + metric app
                 → ((x , T₁) ∷ ∅) ⊢ app f x ∶ T₂ ↓〈 q , q' 〉

        of/wkn : ∀ (Γ : Ctx)(E : Exp)(T : Tp)(q q' : ℕ)(v : Var)(T' : Tp)
                 → fresh v Γ
                 → ShareOK T' T' T'
                 → Γ ⊢ E ∶ T ↓〈 q , q' 〉
                 → ((v , T') ∷ Γ) ⊢ E ∶ T ↓〈 q , q' 〉

        of/rlx : ∀ (Γ : Ctx)(E : Exp)(T : Tp)(p p' q q' : ℕ)
                 → Γ ⊢ E ∶ T ↓〈 p , p' 〉
                 → p ≤ q
                 → q + p' ≤ q' + p
                 → Γ ⊢ E ∶ T ↓〈 q , q' 〉

        of/exg : ∀ (Γ₁ Γ₂ : Ctx)(E : Exp)(T : Tp)(q q' : ℕ)
                 → (Γ₁ ++ Γ₂) ⊢ E ∶ T ↓〈 q , q' 〉
                 → (Γ₂ ++ Γ₁) ⊢ E ∶ T ↓〈 q , q' 〉

        of/sub : ∀ (Γ : Ctx)(E : Exp)(T₁ T₂ : Tp)(q q' : ℕ)
                 → T₁ <∶ T₂
                 → Γ ⊢ E ∶ T₁ ↓〈 q , q' 〉
                 → Γ ⊢ E ∶ T₂ ↓〈 q , q' 〉

        of/sup : ∀ (v : Var)(Γ : Ctx)(E : Exp)(T₁ T₂ T₃ : Tp)(q q' : ℕ)
                 → T₁ <∶ T₂
                 → ((v , T₂) ∷ Γ) ⊢ E ∶ T₃ ↓〈 q , q' 〉
                 → ((v , T₁) ∷ Γ) ⊢ E ∶ T₃ ↓〈 q , q' 〉

    SigOK : Sig → Set
    SigOK Δ = ∀{f : FID}{x : Var}{E : Exp}{T₁ T₂ : Tp}{q q' : ℕ}
              → Δ f ≡ ((T₁ , q , q' , T₂) , x , E)
              → ((x , T₁) ∷ ∅) ⊢ E ∶ T₂ ↓〈 q , q' 〉
