-- Author: Mario Dehesa Azuara (mdehazu@gmail.com)

open import Context
open import Environment
open import NatUtil
open import Potential
open import Syntax

open import Data.Bool using (true;false)
open import Data.Nat using (ℕ;_≤_;_+_;less-than-or-equal;_≤?_;_<_)
open import Data.Nat.Properties using (n≤m+n;m≤m+n;≤⇒≤″;≰⇒>;≤″⇒≤;1+n≰n)
open import Data.Nat.Properties.Simple using (+-assoc;+-comm;+-right-identity)
open import Data.List using (_∷_;_++_) renaming ([] to ∅)
open import Data.Product using (proj₁;proj₂;_,_;_×_;Σ)

open import Relation.Nullary using (Dec;yes;no;¬_)
import Relation.Binary.PropositionalEquality as PropEq
open PropEq using (_≡_;refl;subst₂;cong;sym;cong-app;subst;cong₂;trans)
open PropEq.≡-Reasoning


import Data.Nat as Nat
open Nat.≤-Reasoning
  renaming (begin_ to start_; _∎ to _□; _≡⟨_⟩_ to _≡⟨_⟩'_)



module Soundness(metric : Oper → ℕ)(Δ : Sig) where
    open import BigStep metric Δ
    open import Statics metric Δ
    open import Preservation metric Δ

    prod-eq₆ : ∀ {A B C D E F : Set}
                 {a₁ a₂ : A} {b₁ b₂ : B} {c₁ c₂ : C}
                 {d₁ d₂ : D} {e₁ e₂ : E} {f₁ f₂ : F}
               → ((a₁ , b₁ , c₁ , d₁) , e₁ , f₁) ≡ ((a₂ , b₂ , c₂ , d₂) , e₂ , f₂)
               → (a₁ ≡ a₂) × (b₁ ≡ b₂) × (c₁ ≡ c₂)
               × (d₁ ≡ d₂) × (e₁ ≡ e₂) × (f₁ ≡ f₂)
    prod-eq₆ refl = refl , refl , refl , refl , refl , refl


    lowerbound : ∀ (Γ : Ctx)(Ω : Env)(ok : EnvOK Ω Γ)
                  (E : Exp)(V : Val)(T : Tp){q q' p p' : ℕ}
                  (DS : Γ ⊢ E ∶ T ↓〈 q , q' 〉)
                  (DE : Ω ⊢ E ⇓ V ∣〈 p , p' 〉)
                  (sok : SigOK Δ)
                 → p' + pot Γ ok + q  ≤ p + (q' + pot-val (preservation DS DE ok sok))
    lowerbound .((v , T) ∷ ∅) Ω ok .(var v) .(proj₁ V) T
              (of/var v .T) (step/var .Ω .v V p p' x₁) sok =
      start
        p' + pot Γ ok + metric var ≡⟨ +-assoc-comm p' (pot Γ ok) (metric var) ⟩'
        p' + metric var + pot Γ ok ≡⟨ step₁ ⟩'
        p + pot-val resok          □
        where resok = preservation (of/var v T) (step/var Ω v V p p' x₁) ok sok
              Γ = ((v , T) ∷ ∅)
              step₁ = cong₂ (λ a b → a + b)
                            (sym x₁)
                            (sym (pot-sing-eq ok resok (sym (proj₂ V))))
    lowerbound .∅ Ω ok/nil .true .true .bool
              of/true (step/true .Ω p p' x₁) sok =
      start
        p' + pot {Ω} ∅ ok/nil + metric true ≡⟨ step₀ ⟩'
        p' + metric true + pot {Ω} ∅ ok/nil ≡⟨ refl ⟩'
        p' + metric true +     0            ≡⟨ cong (λ a → a + 0) (sym x₁) ⟩'
        p + 0                               ≡⟨ refl ⟩'
        p + pot-val vok/tt                  □
        where step₀ = +-assoc-comm p' (pot {Ω} ∅ ok/nil) (metric true)
    lowerbound .∅ Ω ok/nil .false .false .bool
             of/false (step/false .Ω p p' x₁) sok =
      start
        p' + pot {Ω} ∅ ok/nil + metric false ≡⟨ step₀ ⟩'
        p' + metric false + pot {Ω} ∅ ok/nil ≡⟨ refl ⟩'
        p' + metric false +     0            ≡⟨ cong (λ a → a + 0) (sym x₁) ⟩'
        p + 0                               ≡⟨ refl ⟩'
        p + pot-val vok/tt                  □
        where step₀ = +-assoc-comm p' (pot {Ω} ∅ ok/nil) (metric false)
    lowerbound .((x , bool) ∷ Γ) Ω (ok/cons refl vok ok) .(if x E₁ E₂) V T
              (of/if Γ x E₁ E₂ .T q₁ q₂ q q' DF x₁ DS₁ x₂ DS₂)
              (step/if₁ .Ω .x .E₁ .E₂ .V p₁ p p' Ω' DE x₄) sok =
        start
          p' + (pot-val vok + pot Γ ok) + q      ≡⟨ step₀ ⟩'
          p' + pot Γ ok + (q₁ + metric if₁)      ≡⟨ step₁ ⟩'
          p' + pot Γ ok + q₁ + metric if₁        ≤⟨ step₂ ⟩
          p₁ + (q' + pot-val resok) + metric if₁ ≡⟨ step₃ ⟩'
          p₁ + metric if₁ + (q' + pot-val resok) ≡⟨ step₄ ⟩'
          p + (q' + pot-val resok)               □
          where
            resok = preservation (of/if Γ x E₁ E₂ T q₁ q₂ q q' DF x₁ DS₁ x₂ DS₂)
                                 (step/if₁ Ω x E₁ E₂ V p₁ p p' Ω' DE x₄)
                                 (ok/cons refl vok ok)
                                 sok
            IH : p' + pot Γ ok + q₁ ≤ p₁ + (q' + pot-val resok)
            IH = lowerbound Γ Ω ok E₁ V T DS₁ DE sok

            H₀ : pot-val vok + pot Γ ok ≡ pot Γ ok
            H₀ = cong (λ a → a + pot Γ ok) (pot-val-eq vok vok/tt Ω')

            step₀ = cong₂ (λ a b → p' + a + b) H₀ x₁
            step₁ = sym (+-assoc (p' + pot Γ ok) q₁ (metric if₁))
            step₂ = p≤q⇒p+n≤q+n (metric if₁) IH
            step₃ = +-assoc-comm p₁ (q' + pot-val resok) (metric if₁)
            step₄ = cong (λ a → a + (q' + pot-val resok)) (sym x₄)
    lowerbound .((x , bool) ∷ Γ) Ω (ok/cons refl vok ok) .(if x E₁ E₂) V T
              (of/if Γ x E₁ E₂ .T q₁ q₂ q q' x₁ DF DS₁ x₂ DS₂)
              (step/if₂ .Ω .x .E₁ .E₂ .V p₂ p p' Ω' DE x₄)
              sok =
        start
          p' + (pot-val vok + pot Γ ok) + q      ≡⟨ step₀ ⟩'
          p' + pot Γ ok + (q₂ + metric if₂)      ≡⟨ step₁ ⟩'
          p' + pot Γ ok + q₂ + metric if₂        ≤⟨ step₂ ⟩
          p₂ + (q' + pot-val resok) + metric if₂ ≡⟨ step₃ ⟩'
          p₂ + metric if₂ + (q' + pot-val resok) ≡⟨ step₄ ⟩'
          p + (q' + pot-val resok)               □
          where
            resok = preservation (of/if Γ x E₁ E₂ T q₁ q₂ q q' x₁ DF DS₁ x₂ DS₂)
                                 (step/if₂ Ω x E₁ E₂ V p₂ p p' Ω' DE x₄)
                                 (ok/cons refl vok ok)
                                 sok
            IH : p' + pot Γ ok + q₂ ≤ p₂ + (q' + pot-val resok)
            IH = lowerbound Γ Ω ok E₂ V T DS₂ DE sok

            H₀ : pot-val vok + pot Γ ok ≡ pot Γ ok
            H₀ = cong (λ a → a + pot Γ ok) (pot-val-eq vok vok/ff Ω')

            step₀ = cong₂ (λ a b → p' + a + b) H₀ x₂
            step₁ = sym (+-assoc (p' + pot Γ ok) q₂ (metric if₂))
            step₂ = p≤q⇒p+n≤q+n (metric if₂) IH
            step₃ = +-assoc-comm p₂ (q' + pot-val resok) (metric if₂)
            step₄ = cong (λ a → a + (q' + pot-val resok)) (sym x₄)
    lowerbound .(Γ₁ ++ Γ₂) Ω ok .(elet E₁ (v , E₂)) V T
              (of/let Γ₁ Γ₂ E₁ E₂ v T₁ .T q₁ q₂ q q' DF DS₁ x DS)
              (step/let .Ω .E₁ .E₂ .v V₁ .V p₁ p₂ p p' DE₁ Ω' DE x₁) sok =
      let
        Ω'' = proj₁ Ω'

        DF' : fresh v Γ₂
        DF' = fresh-++₂ v Γ₁ Γ₂ DF

        ok₁ : EnvOK Ω Γ₁
        ok₁ = ok-append₁ Γ₁ Γ₂ ok

        ok₂ : EnvOK Ω Γ₂
        ok₂ = ok-append₂ Γ₁ Γ₂ ok

        vok₁ : ValOK V₁ T₁
        vok₁ = preservation DS₁ DE₁ ok₁ sok

        ok-ex : EnvOK (v , V₁ ∣ Ω) Γ₂
        ok-ex = ok-extend Γ₂ v ok₂ DF'

        ok-ex' : EnvOK Ω'' Γ₂
        ok-ex' = subst₂ EnvOK (sym (proj₂ Ω')) refl ok-ex

        ok₂' : EnvOK Ω'' ((v , T₁) ∷ Γ₂)
        ok₂' = ok/cons (trans (cong-app (proj₂ Ω') v) (env-extend v))
                       vok₁
                       ok-ex'

        vok : ValOK V T
        vok = preservation (of/let Γ₁ Γ₂ E₁ E₂ v T₁ T q₁ q₂ q q' DF DS₁ x DS)
                           (step/let Ω E₁ E₂ v V₁ V p₁ p₂ p p' DE₁ Ω' DE x₁)
                           ok
                           sok

        pot-eq₀ : pot Γ₂ ok-ex' ≡ pot Γ₂ ok-ex
        pot-eq₀ = pot-env-eq Γ₂ ok-ex' ok-ex (proj₂ Ω')

        pot-eq₁ : pot Γ₂ ok-ex ≡ pot Γ₂ ok₂
        pot-eq₁ = (sym (pot-extend-fresh {v} Γ₂ ok₂ ok-ex DF'))

        IH₁ : p₂ + pot Γ₁ ok₁ + q₁ ≤ p₁ + (q₂ + pot-val vok₁)
        IH₁ = lowerbound Γ₁ Ω ok₁ E₁ V₁ T₁ DS₁ DE₁ sok

        IH₂ : p' + (pot ((v , T₁) ∷ Γ₂) ok₂') + q₂ ≤ p₂ + (q' + pot-val vok)
        IH₂ = lowerbound ((v , T₁) ∷ Γ₂) Ω'' ok₂' E₂ V T DS DE sok

        step₀ = +-assoc-comm (pot Γ₁ ok₁) q p₂
        step₁ = cong (λ a → a + q) (+-comm (pot Γ₁ ok₁) p₂)
        step₂ = cong (λ a → p₂ + pot Γ₁ ok₁ + a) x
        step₃ = sym (+-assoc (p₂ + pot Γ₁ ok₁) q₁ (metric elet))
        step₄ = p≤q⇒p+n≤q+n (metric elet) IH₁
        step₅ = +-assoc-comm p₁ (q₂ + pot-val vok₁) (metric elet)
        step₆ = cong (λ a → a + (q₂ + pot-val vok₁)) (sym x₁)
        step₇ = sym (+-assoc p q₂ (pot-val vok₁))

        H₀ : pot Γ₁ ok₁ + q + p₂ ≤ p + q₂ + pot-val vok₁
        H₀ = start
         pot Γ₁ ok₁ + q + p₂                    ≡⟨ step₀ ⟩'
         pot Γ₁ ok₁ + p₂ + q                    ≡⟨ step₁ ⟩'
         p₂ + pot Γ₁ ok₁ + q                    ≡⟨ step₂ ⟩'
         p₂ + pot Γ₁ ok₁ + (q₁ + metric elet)   ≡⟨ step₃ ⟩'
         p₂ + pot Γ₁ ok₁ + q₁ + metric elet     ≤⟨ step₄ ⟩
         p₁ + (q₂ + pot-val vok₁) + metric elet ≡⟨ step₅ ⟩'
         p₁ + metric elet + (q₂ + pot-val vok₁) ≡⟨ step₆ ⟩'
         p + (q₂ + pot-val vok₁)                ≡⟨ step₇ ⟩'
         p + q₂ + pot-val vok₁                  □


        step₀ = +-assoc-comm (p' + pot Γ₂ ok₂) q₂ (pot-val vok₁)
        step₁ = cong (λ a → a + q₂) (+-assoc p' (pot Γ₂ ok₂) (pot-val vok₁))
        step₂ = cong (λ a → p' + a + q₂) (+-comm (pot Γ₂ ok₂) (pot-val vok₁))
        step₃ = cong (λ a → p' + (pot-val vok₁ + a) + q₂)
                     (trans (sym pot-eq₁) (sym pot-eq₀))
        step₄ = +-comm p₂ (q' + pot-val vok)
        H₁ : p' + pot Γ₂ ok₂ + q₂ + pot-val vok₁ ≤ (q' + pot-val vok) + p₂
        H₁ = start
          p' + pot Γ₂ ok₂ + q₂ + pot-val vok₁      ≡⟨ step₀ ⟩'
          p' + pot Γ₂ ok₂ + pot-val vok₁ + q₂      ≡⟨ step₁ ⟩'
          p' + (pot Γ₂ ok₂ + pot-val vok₁) + q₂    ≡⟨ step₂ ⟩'
          p' + (pot-val vok₁ + pot Γ₂ ok₂) + q₂    ≡⟨ step₃ ⟩'
          p' + (pot-val vok₁ + pot Γ₂ ok-ex') + q₂ ≡⟨ refl ⟩'
          p' + (pot ((v , T₁) ∷ Γ₂) ok₂') + q₂     ≤⟨ IH₂ ⟩
          p₂ + (q' + pot-val vok)                  ≡⟨ step₄ ⟩'
          (q' + pot-val vok) + p₂                  □

        H₂ : (p' + pot Γ₂ ok₂ + q₂ + pot-val vok₁) + (pot Γ₁ ok₁ + q + p₂) ≤
             ((q' + pot-val vok) + p₂) + (p + q₂ + pot-val vok₁)
        H₂ = le-add H₁ H₀

        step₀ = +-assoc (p' + pot Γ₂ ok₂ + q₂) (pot Γ₁ ok₁ + q + p₂) (pot-val vok₁)
        step₁ = cong (λ a → (p' + pot Γ₂ ok₂ + q₂) + a)
                            (+-comm (pot Γ₁ ok₁ + q + p₂) (pot-val vok₁))
        step₂ = sym (+-assoc (p' + pot Γ₂ ok₂ + q₂)
                             (pot-val vok₁)
                             (pot Γ₁ ok₁ + q + p₂))
        step₃ = sym (+-assoc ((q' + pot-val vok) + p₂) (p + q₂) (pot-val vok₁))

        H₃ : (p' + pot Γ₂ ok₂ + q₂) + (pot Γ₁ ok₁ + q + p₂) + pot-val vok₁ ≤
             ((q' + pot-val vok) + p₂) + (p + q₂) + pot-val vok₁
        H₃ = start
          (p' + pot Γ₂ ok₂ + q₂) + (pot Γ₁ ok₁ + q + p₂) + pot-val vok₁   ≡⟨ step₀ ⟩'
          (p' + pot Γ₂ ok₂ + q₂) + ((pot Γ₁ ok₁ + q + p₂) + pot-val vok₁) ≡⟨ step₁ ⟩'
          (p' + pot Γ₂ ok₂ + q₂) + (pot-val vok₁ + (pot Γ₁ ok₁ + q + p₂)) ≡⟨ step₂ ⟩'
          (p' + pot Γ₂ ok₂ + q₂ + pot-val vok₁) + (pot Γ₁ ok₁ + q + p₂)   ≤⟨ H₂ ⟩
          ((q' + pot-val vok) + p₂) + ((p + q₂) + pot-val vok₁)           ≡⟨ step₃ ⟩'
          ((q' + pot-val vok) + p₂) + (p + q₂) + pot-val vok₁             □

        H₄ : (p' + pot Γ₂ ok₂ + q₂) + (pot Γ₁ ok₁ + q + p₂) ≤
             ((q' + pot-val vok) + p₂) + (p + q₂)
        H₄ = p+n≤q+n⇒p≤q (pot-val vok₁) H₃

        step₀ = +-assoc (p' + pot Γ₂ ok₂) (pot Γ₁ ok₁ + q + p₂) q₂
        step₁ = cong (λ a → (p' + pot Γ₂ ok₂) + a) (+-comm (pot Γ₁ ok₁ + q + p₂) q₂)
        step₂ = sym (+-assoc (p' + pot Γ₂ ok₂) q₂ (pot Γ₁ ok₁ + q + p₂))
        step₃ = sym (+-assoc ((q' + pot-val vok) + p₂) p q₂)

        H₅ : (p' + pot Γ₂ ok₂) + (pot Γ₁ ok₁ + q + p₂) + q₂ ≤
             ((q' + pot-val vok) + p₂) + p + q₂
        H₅ = start
          (p' + pot Γ₂ ok₂) + (pot Γ₁ ok₁ + q + p₂) + q₂   ≡⟨ step₀ ⟩'
          (p' + pot Γ₂ ok₂) + ((pot Γ₁ ok₁ + q + p₂) + q₂) ≡⟨ step₁ ⟩'
          (p' + pot Γ₂ ok₂) + (q₂ + (pot Γ₁ ok₁ + q + p₂)) ≡⟨ step₂ ⟩'
          (p' + pot Γ₂ ok₂ + q₂) + (pot Γ₁ ok₁ + q + p₂)   ≤⟨ H₄ ⟩
          ((q' + pot-val vok) + p₂) + (p + q₂)             ≡⟨ step₃ ⟩'
          ((q' + pot-val vok) + p₂) + p + q₂               □

        H₆ : (p' + pot Γ₂ ok₂) + (pot Γ₁ ok₁ + q + p₂) ≤ ((q' + pot-val vok) + p₂) + p
        H₆ = p+n≤q+n⇒p≤q q₂ H₅

        step₀ = +-assoc (p' + pot Γ₂ ok₂) (pot Γ₁ ok₁ + q) p₂
        step₁ = +-assoc-comm (q' + pot-val vok) p₂ p
        H₇ : (p' + pot Γ₂ ok₂) + (pot Γ₁ ok₁ + q) + p₂ ≤ (q' + pot-val vok) + p + p₂
        H₇ = start
          (p' + pot Γ₂ ok₂) + (pot Γ₁ ok₁ + q) + p₂   ≡⟨ step₀ ⟩'
          (p' + pot Γ₂ ok₂) + ((pot Γ₁ ok₁ + q) + p₂) ≤⟨ H₆ ⟩
          ((q' + pot-val vok) + p₂) + p               ≡⟨ step₁ ⟩'
          (q' + pot-val vok) + p + p₂                 □

        H₈ : (p' + pot Γ₂ ok₂) + (pot Γ₁ ok₁ + q) ≤ (q' + pot-val vok) + p
        H₈ = p+n≤q+n⇒p≤q p₂ H₇

        step₀ = cong (λ a → p' + a + q) (pot-concat Γ₁ Γ₂ ok ok₁ ok₂)
        step₁ = cong (λ a → p' + a + q) (+-comm (pot Γ₁ ok₁) (pot Γ₂ ok₂))
        step₂ = cong (λ a → a + q) (sym (+-assoc p' (pot Γ₂ ok₂) (pot Γ₁ ok₁)))
        step₃ = +-assoc (p' + pot Γ₂ ok₂) (pot Γ₁ ok₁) q
        step₄ = +-comm (q' + pot-val vok) p
        H₉ : p' + pot (Γ₁ ++ Γ₂) ok + q ≤ p + (q' + pot-val vok)
        H₉ = start
          p' + pot (Γ₁ ++ Γ₂) ok + q           ≡⟨ step₀ ⟩'
          p' + (pot Γ₁ ok₁ + pot Γ₂ ok₂) + q   ≡⟨ step₁ ⟩'
          p' + (pot Γ₂ ok₂ + pot Γ₁ ok₁) + q   ≡⟨ step₂ ⟩'
          p' + pot Γ₂ ok₂ + pot Γ₁ ok₁ + q     ≡⟨ step₃ ⟩'
          (p' + pot Γ₂ ok₂) + (pot Γ₁ ok₁ + q) ≤⟨ H₈ ⟩
          (q' + pot-val vok) + p               ≡⟨ step₄ ⟩'
          p + (q' + pot-val vok) □

      in H₉
    lowerbound .∅ Ω ok/nil .nil .nil .(list m T)
              (of/nil T m) (step/nil .Ω p p' x₁) sok =
      start
        p' + 0 + metric nil ≡⟨ cong (λ a → a + metric nil) (+-right-identity p') ⟩'
        p' + metric nil     ≡⟨ sym x₁ ⟩'
        p                   ≡⟨ sym (+-right-identity p) ⟩'
        p + 0               □
    lowerbound .((v₁ , T) ∷ (v₂ , list m T) ∷ ∅) Ω
              (ok/cons refl vokh (ok/cons refl vokt ok/nil))
              .(cons v₁ v₂)
              .(cons (proj₁ V) (proj₁ VS)) .(list m T)
              (of/cons v₁ v₂ T m)
              (step/cons .Ω .v₁ .v₂ p p' x₁ V VS) sok =
      start
        p' + (pot-val vokh + (pot-val vokt + 0)) + (metric cons + m) ≡⟨ step₀ ⟩'
        p' + (pot-val vokh + (pot-val vokt + 0)) + metric cons + m   ≡⟨ step₁ ⟩'
        p' + metric cons + (pot-val vokh + (pot-val vokt + 0)) + m   ≡⟨ step₂ ⟩'
        p + (pot-val vokh + (pot-val vokt + 0)) + m                  ≡⟨ step₃ ⟩'
        p + (pot-val vokh + pot-val vokt) + m                        ≡⟨ step₄ ⟩'
        p + (pot-val vokh + pot-val vokt + m)                        ≡⟨ step₅ ⟩'
        p + pot-val consok                                           □
        where
          consok = preservation (of/cons v₁ v₂ T m)
                                (step/cons Ω v₁ v₂ p p' x₁ V VS)
                                (ok/cons refl vokh (ok/cons refl vokt ok/nil))
                                sok
          step₀ = sym (+-assoc (p' + (pot-val vokh + (pot-val vokt + 0)))
                               (metric cons)
                               m)
          step₁ = cong (λ a → a + m)
                       (+-assoc-comm p'
                                     (pot-val vokh + (pot-val vokt + 0))
                                     (metric cons))
          step₂ = cong (λ a → a + (pot-val vokh + (pot-val vokt + 0)) + m) (sym x₁)
          step₃ = cong (λ a → p + (pot-val vokh + a) + m)
                       (+-right-identity (pot-val vokt))
          step₄ = +-assoc p (pot-val vokh + pot-val vokt) m
          step₅ = cong (λ a → p + a)
                       (pot-cons vokh vokt consok (sym (proj₂ V)) (sym (proj₂ VS)))
    lowerbound .((v , list m T) ∷ Γ) Ω (ok/cons refl vok ok)
              .(matl v E₁ (v₁ , v₂ , E₂)) V T₁
              (of/matl Γ v v₁ v₂ E₁ E₂ T .T₁ q q' q₁ q₂ m DF DF₁ DF₂ x DS₁ x₁ DS₂)
              (step/matl₁ .Ω .v .v₁ .v₂ .E₁ .E₂ .V p₁ p p' x₂ x₃ DE) sok =
      start
        p' + (pot-val vok + pot Γ ok) + q        ≡⟨ step₀ ⟩'
        p' + pot Γ ok + q                        ≡⟨ step₁ ⟩'
        p' + pot Γ ok + (q₁ + metric matl₁)      ≡⟨ step₂ ⟩'
        p' + pot Γ ok + q₁ + metric matl₁        ≤⟨ step₃ ⟩
        p₁ + (q' + pot-val resok) + metric matl₁ ≡⟨ step₄ ⟩'
        p₁ + metric matl₁ + (q' + pot-val resok) ≡⟨ step₅ ⟩'
        p + (q' + pot-val resok)                 □
        where
          resok = preservation
                  (of/matl Γ v v₁ v₂ E₁ E₂ T T₁ q q' q₁ q₂ m DF DF₁ DF₂ x DS₁ x₁ DS₂)
                  (step/matl₁ Ω v v₁ v₂ E₁ E₂ V p₁ p p' x₂ x₃ DE)
                  (ok/cons refl vok ok)
                  sok
          IH : p' + pot Γ ok + q₁ ≤ p₁ + (q' + pot-val resok)
          IH = lowerbound Γ Ω ok E₁ V T₁ DS₁ DE sok
          step₀ = cong (λ a → p' + (a + pot Γ ok) + q) (pot-val-eq vok vok/nil x₂)
          step₁ = cong (λ a → p' + pot Γ ok + a) x
          step₂ = sym (+-assoc (p' + pot Γ ok) q₁ (metric matl₁))
          step₃ = p≤q⇒p+n≤q+n (metric matl₁) IH
          step₄ = +-assoc-comm p₁ (q' + pot-val resok) (metric matl₁)
          step₅ = cong (λ a → a + (q' + pot-val resok)) (sym x₃)
    lowerbound .((v , list m T) ∷ Γ) Ω (ok/cons refl vok ok)
              .(matl v E₁ (x , xs , E₂)) V T₁
              (of/matl Γ v x xs E₁ E₂ T .T₁ q q' q₁ q₂ m DF DF₁ DF₂ eq₀ DS eq₁ DS₁)
              (step/matl₂ .Ω .v .x .xs .E₁ .E₂ X XS .V p₁ p p' eq₂ H DE eq₃) sok =
      let
        (vokh , vokt) = vok-cons vok eq₂
        Ω' = proj₁ H
        cost = metric matl₂

        ok' : EnvOK Ω ((v , list m T) ∷ Γ)
        ok' = ok/cons refl vok ok

        vok' : ValOK V T₁
        vok' = preservation
                (of/matl Γ v x xs E₁ E₂ T T₁ q q' q₁ q₂ m DF DF₁ DF₂ eq₀ DS eq₁ DS₁)
                (step/matl₂ Ω v x xs E₁ E₂ X XS V p₁ p p' eq₂ H DE eq₃)
                ok'
                sok

        ok-ex₁ : EnvOK (xs , XS ∣ Ω) Γ
        ok-ex₁ = ok-extend Γ xs ok (fresh-wkn DF₂)

        ok-ex₂ : EnvOK (x , X ∣ (xs , XS ∣ Ω)) Γ
        ok-ex₂ = ok-extend Γ x ok-ex₁ (fresh-wkn DF₁)

        ok-ex : EnvOK Ω' Γ
        ok-ex = subst₂ EnvOK (sym (proj₂ H)) refl ok-ex₂

        Γ' : Ctx
        Γ' = (x , T) ∷ (xs , list m T) ∷ Γ

        P = pot-val vokh + pot-val vokt + pot Γ ok

        H₁ : (x , X ∣ (xs , XS ∣ Ω)) x ≡ X
        H₁ = env-extend x

        H₂ : (x , X ∣ (xs , XS ∣ Ω)) xs ≡ XS
        H₂ = env-extend₂ x xs DF₂

        H₃ : Ω' x ≡ X
        H₃ = trans (cong (λ y → y x) (proj₂ H)) H₁

        vok₁ : ValOK (Ω' x) T
        vok₁ = subst₂ ValOK (sym H₃) refl vokh

        H₄ : Ω' xs ≡ XS
        H₄ = trans (cong (λ y → y xs) (proj₂ H)) H₂

        vok₂ : ValOK (Ω' xs) (list m T)
        vok₂ = subst₂ ValOK (sym H₄) refl vokt

        H₅ : pot Γ ok-ex₂ ≡ pot Γ ok-ex
        H₅ = pot-env-eq Γ ok-ex₂ ok-ex (sym (proj₂ H))

        H₆ : pot Γ ok-ex₁ ≡ pot Γ ok-ex₂
        H₆ = pot-extend-fresh Γ ok-ex₁ ok-ex₂ (fresh-wkn DF₁)

        H₇ : pot Γ ok ≡ pot Γ ok-ex₁
        H₇ = pot-extend-fresh Γ ok ok-ex₁ (fresh-wkn DF₂)

        -- Done.
        ok' : EnvOK Ω' Γ'
        ok' = ok/cons refl vok₁ (ok/cons refl vok₂ ok-ex)

        resvok : ValOK V T₁
        resvok = preservation DS₁ DE ok' sok

        IH : p' + (pot-val vok₁ + (pot-val vok₂ + pot Γ ok-ex)) + q₂ ≤
             p₁ + (q' + pot-val resvok)
        IH = lowerbound Γ' Ω' ok' E₂ V T₁ DS₁ DE sok

        step₀ = cong₂ (λ a b → p' + (a + b + pot Γ ok) + q₂)
                      (sym (pot-val-eq vok₁ vokh H₃))
                      (sym (pot-val-eq vok₂ vokt H₄))
        step₁ = cong (λ a → p' + (pot-val vok₁ + pot-val vok₂ + a) + q₂)
                     (trans H₇ (trans H₆ H₅))
        step₂ = cong (λ a → p' + a + q₂)
                     (+-assoc (pot-val vok₁) (pot-val vok₂) (pot Γ ok-ex))
        J₀ : p' + (pot-val vokh + pot-val vokt + pot Γ ok) + q₂ ≤
             p₁ + (q' + pot-val resvok)
        J₀ =
          start
            p' + (pot-val vokh + pot-val vokt + pot Γ ok) + q₂      ≡⟨ step₀ ⟩'
            p' + (pot-val vok₁ + pot-val vok₂ + pot Γ ok) + q₂      ≡⟨ step₁ ⟩'
            p' + (pot-val vok₁ + pot-val vok₂ + pot Γ ok-ex) + q₂   ≡⟨ step₂ ⟩'
            p' + (pot-val vok₁ + (pot-val vok₂ + pot Γ ok-ex)) + q₂ ≤⟨ IH ⟩
            p₁ + (q' + pot-val resvok)                              □

        step₀ = cong (λ a → p' + (a + pot Γ ok) + q)
                     (sym (pot-cons₂ vokh vokt vok (sym eq₂)))
        step₁ = cong (λ a → p' + a + q)
                     (+-assoc-comm (pot-val vokh + pot-val vokt) m (pot Γ ok))
        step₂ = cong (λ a → a + q)
                     (sym (+-assoc p' (pot-val vokh + pot-val vokt + pot Γ ok) m))
        step₃ = +-assoc (p' + (pot-val vokh + pot-val vokt + pot Γ ok)) m q
        step₄ = cong (λ a → p' + (pot-val vokh + pot-val vokt + pot Γ ok) + a)
                     (+-comm m q)
        step₅ = cong (λ a → p' + (pot-val vokh + pot-val vokt + pot Γ ok) + a) eq₁
        step₆ = sym (+-assoc (p' + (pot-val vokh + pot-val vokt + pot Γ ok) )
                             q₂
                             (metric matl₂))
        step₇ = p≤q⇒p+n≤q+n (metric matl₂) J₀
        step₈ = +-assoc-comm p₁ (q' + pot-val resvok) (metric matl₂)
        step₉ = cong₂ (λ a b → a + (q' + b)) (sym eq₃) (pot-val-eq resvok vok' refl)
      in
        start
        p' + (pot-val vok + pot Γ ok) + q                                   ≡⟨ step₀ ⟩'
        p' + (pot-val vokh + pot-val vokt + m + pot Γ ok) + q               ≡⟨ step₁ ⟩'
        p' + (pot-val vokh + pot-val vokt + pot Γ ok + m) + q               ≡⟨ step₂ ⟩'
        p' + (pot-val vokh + pot-val vokt + pot Γ ok) + m + q               ≡⟨ step₃ ⟩'
        p' + (pot-val vokh + pot-val vokt + pot Γ ok) + (m + q)             ≡⟨ step₄ ⟩'
        p' + (pot-val vokh + pot-val vokt + pot Γ ok) + (q + m)             ≡⟨ step₅ ⟩'
        p' + (pot-val vokh + pot-val vokt + pot Γ ok) + (q₂ + metric matl₂) ≡⟨ step₆ ⟩'
        p' + (pot-val vokh + pot-val vokt + pot Γ ok) + q₂ + metric matl₂   ≤⟨ step₇ ⟩
        p₁ + (q' + pot-val resvok) + metric matl₂                           ≡⟨ step₈ ⟩'
        p₁ + metric matl₂ + (q' + pot-val resvok)                           ≡⟨ step₉ ⟩'
        p + (q' + pot-val vok')                                             □
    lowerbound .((x , T) ∷ Γ) .Ω (ok/cons refl vok ok) .(share x (x₁ , x₂ , E)) .V₁ .M
              (of/share Γ x x₁ x₂ E T T₁ T₂ M q q' frsh frsh₁ frsh₂ shareok DS)
              (step/share Ω .x .x₁ .x₂ .E V V₁ p p' eq Ω' DE) sok =
      let
        Γ' = (x₁ , T₁) ∷ (x₂ , T₂) ∷ Γ

        origok : EnvOK Ω ((x , T) ∷ Γ)
        origok = ok/cons refl vok ok

        vok' = preservation
                 (of/share Γ x x₁ x₂ E T T₁ T₂ M q q' frsh frsh₁ frsh₂ shareok DS)
                 (step/share Ω x x₁ x₂ E V V₁ p p' eq Ω' DE)
                 origok
                 sok

        -- Prove that the new environment is okay under the new context.
        ok-ex₁ : EnvOK (x₂ , V ∣ Ω) Γ
        ok-ex₁ = ok-extend Γ x₂ ok (fresh-wkn frsh₂)

        ok-ex₂ : EnvOK (x₁ , V ∣ (x₂ , V ∣ Ω)) Γ
        ok-ex₂ = ok-extend Γ x₁ ok-ex₁ (fresh-wkn frsh₁)

        ok-ex : EnvOK (proj₁ Ω') Γ
        ok-ex = subst₂ EnvOK (sym (proj₂ Ω')) refl ok-ex₂

        env-app : ∀ (v : Var){val : Val} →
                    (x₁ , V ∣ (x₂ , V ∣ Ω)) v ≡ val →
                    (proj₁ Ω') v ≡ val
        env-app v eq = trans (cong-app (proj₂ Ω') v) eq

        H₀ : (proj₁ Ω') x₁ ≡ V
        H₀ = env-app x₁ (env-extend x₁)

        H₁ : (proj₁ Ω') x₂ ≡ V
        H₁ = env-app x₂ (env-extend₂ x₁ x₂ frsh₂)

        vok₁ : ValOK V T₁
        vok₁ = subst₂ ValOK eq refl (ok-share₁ shareok vok)

        vok₂ : ValOK V T₂
        vok₂ = subst₂ ValOK eq refl (ok-share₂ shareok vok)

        ok' : EnvOK (proj₁ Ω') Γ'
        ok' = ok/cons H₀ vok₁ (ok/cons H₁ vok₂ ok-ex)

        H₂ : pot Γ ok ≡ pot Γ ok-ex₁
        H₂ = pot-extend-fresh Γ ok ok-ex₁ (fresh-wkn frsh₂)

        H₃ : pot Γ ok-ex₁ ≡ pot Γ ok-ex₂
        H₃ = pot-extend-fresh Γ ok-ex₁ ok-ex₂ (fresh-wkn frsh₁)

        H₄ : pot Γ ok-ex ≡ pot Γ ok-ex₂
        H₄ = pot-env-eq Γ ok-ex ok-ex₂ (proj₂ Ω')

        -- Prove that the new context has the same amount of potential
        H₅ : pot Γ ok-ex ≡ pot Γ ok
        H₅ = trans H₄ (trans (sym H₃) (sym H₂))

        H₆ : pot-val vok₁ + pot-val vok₂ ≡ pot-val vok
        H₆ = pot-share shareok vok vok₁ vok₂ eq

        resok : ValOK V₁ M
        resok = preservation DS DE ok' sok

        step₀ = cong (λ a → p' + (a + pot Γ ok) + q) (sym H₆)
        step₁ = cong (λ a → p' + (pot-val vok₁ + pot-val vok₂ + a) + q) (sym H₅)
        step₂ = cong (λ a → p' + a + q)
                     (+-assoc (pot-val vok₁) (pot-val vok₂) (pot Γ ok-ex))
        step₃ = lowerbound Γ' (proj₁ Ω') ok' E V₁ M DS DE sok
        step₄ = cong (λ a → p + (q' + a)) (pot-val-eq resok vok' refl)
      in
        start
        p' + (pot-val vok + pot Γ ok) + q                      ≡⟨ step₀ ⟩'
        p' + (pot-val vok₁ + pot-val vok₂ + pot Γ ok) + q      ≡⟨ step₁ ⟩'
        p' + (pot-val vok₁ + pot-val vok₂ + pot Γ ok-ex) + q   ≡⟨ step₂ ⟩'
        p' + (pot-val vok₁ + (pot-val vok₂ + pot Γ ok-ex)) + q ≤⟨ step₃ ⟩
        p + (q' + pot-val resok)                               ≡⟨ step₄ ⟩'
        p + (q' + pot-val vok')                                □
    lowerbound .((x , T₁) ∷ ∅) Ω (ok/cons refl vok ok/nil) .(app fd x) V₂ T₂
              (of/app x x₁ T₁ .T₂ fd q q₁ q' E eq eq₂)
              (step/app .Ω .fd .x x₂ V₁ .V₂ E₁ p p₁ p' T₃ T₄ j j' eq₃ eq₄ eq₅ DE)
              sok =
      let
        resok = preservation
                  (of/app x x₁ T₁ T₂ fd q q₁ q' E eq eq₂)
                  (step/app Ω fd x x₂ V₁ V₂ E₁ p p₁ p' T₃ T₄ j j' eq₃ eq₄ eq₅ DE)
                  (ok/cons refl vok ok/nil)
                  sok

        H₀ : ((T₁ , q₁ , q' , T₂) , x₁ , E) ≡ ((T₃ , j , j' , T₄) , x₂ , E₁)
        H₀ = trans (sym eq) eq₄

        (eqT₁T₃ , eqq₁j , eqq'j' , eqT₂T₄ , eqx₁x₂ , eqEE₁ ) = prod-eq₆ H₀

        vok' : ValOK V₁ T₃
        vok' = subst₂ ValOK eq₃ eqT₁T₃ vok

        H₁ : EnvOK ((x₂ , V₁ ∣ ◎)) ((x₂ , T₃) ∷ ∅)
        H₁ = ok/cons (env-extend x₂) vok' ok/nil

        resok' = preservation (sok eq₄) DE H₁ sok

        IH : p' + (pot-val vok' + 0) + j ≤ p₁ + (j' + pot-val resok')
        IH = lowerbound ((x₂ , T₃) ∷ ∅) (x₂ , V₁ ∣ ◎) H₁ E₁ V₂ T₄ (sok eq₄) DE sok

        H₃ : p' + (pot-val vok' + 0) + q₁ ≤ p₁ + (q' + pot-val resok')
        H₃ = subst₂
              (λ a b → p' + (pot-val vok' + 0) + a ≤ p₁ + (b + pot-val resok'))
              (sym eqq₁j) (sym eqq'j') IH

        step₀ = cong (λ a → p' + (a + 0) + q) (pot-val-eq₂ vok vok' eq₃ eqT₁T₃)
        step₁ = cong (λ a → p' + (pot-val vok' + 0) + a) eq₂
        step₂ = sym (+-assoc (p' + (pot-val vok' + 0)) q₁ (metric app))
        step₃ = n≤m⇒n+k≤m+k (p' + (pot-val vok' + 0) + q₁)
                            (p₁ + (q' + pot-val resok')) (metric app) H₃
        step₄ = +-assoc-comm p₁ (q' + pot-val resok') (metric app)
        step₅ = cong (λ a → a + (q' + pot-val resok')) (sym eq₅)
        step₆ = cong (λ a → p + (q' + a)) (pot-val-eq₂ resok' resok refl (sym eqT₂T₄))
      in
        start
          p' + (pot-val vok + 0) + q                  ≡⟨ step₀ ⟩'
          p' + (pot-val vok' + 0) + q                 ≡⟨ step₁ ⟩'
          p' + (pot-val vok' + 0) + (q₁ + metric app) ≡⟨ step₂ ⟩'
          p' + (pot-val vok' + 0) + q₁ + metric app   ≤⟨ step₃ ⟩
          p₁ + (q' + pot-val resok') + metric app     ≡⟨ step₄ ⟩'
          p₁ + metric app + (q' + pot-val resok')     ≡⟨ step₅ ⟩'
          p + (q' + pot-val resok')                   ≡⟨ step₆ ⟩'
          p + (q' + pot-val resok)                    □
    lowerbound .((v , T') ∷ Γ) Ω (ok/cons eq vok ok) E V T {.q} {.q'} {p} {p'}
               (of/wkn Γ .E .T q q' v T' DF shareok DS) DE sok =
      start
        p' + (pot-val vok + pot Γ ok) + q ≡⟨ step₀ ⟩'
        p' + pot Γ ok + q                 ≤⟨ IH ⟩
        p + (q' + pot-val resok)          □
        where
          resok = preservation DS DE ok sok
          IH = lowerbound Γ Ω ok E V T DS DE sok
          step₀ = cong (λ a → p' + (a + pot Γ ok) + q) (pot-share-same shareok vok)
    lowerbound Γ Ω ok E V T {.q} {.q'} {p} {p'}
               (of/rlx .Γ .E .T q₁ q₂ q q' DS x x₁) DE sok =
      let
        resok = preservation DS DE ok sok

        IH : p' + pot Γ ok + q₁ ≤ p + (q₂ + pot-val resok)
        IH = lowerbound Γ Ω ok E V T DS DE sok

        H₀ : (p' + pot Γ ok + q₁) + (q + q₂) ≤ (p + (q₂ + pot-val resok)) + (q' + q₁)
        H₀ = le-add IH x₁

        step₀ = +-assoc-comm (p' + pot Γ ok) (q + q₂) q₁
        step₁ = H₀
        step₂ = sym (+-assoc (p + (q₂ + pot-val resok)) q' q₁)
        H₁ : (p' + pot Γ ok) + (q + q₂) + q₁ ≤ (p + (q₂ + pot-val resok)) + q' + q₁
        H₁ =
          start
            (p' + pot Γ ok) + (q + q₂) + q₁        ≡⟨ step₀ ⟩'
            (p' + pot Γ ok + q₁) + (q + q₂)        ≤⟨ step₁ ⟩
            (p + (q₂ + pot-val resok)) + (q' + q₁) ≡⟨ step₂ ⟩'
            (p + (q₂ + pot-val resok)) + q' + q₁   □

        H₂ :  (p' + pot Γ ok) + (q + q₂) ≤ (p + (q₂ + pot-val resok)) + q'
        H₂ = p+n≤q+n⇒p≤q q₁ H₁

        step₀ = +-assoc (p' + pot Γ ok) q q₂
        step₁ = H₂
        step₂ = cong (λ a → (p + a) + q') (+-comm q₂ (pot-val resok))
        step₃ = cong (λ a → a + q') (sym (+-assoc p (pot-val resok) q₂))
        step₄ = +-assoc-comm (p + pot-val resok) q₂ q'
        H₃ : (p' + pot Γ ok) + q + q₂ ≤ (p + pot-val resok) + q' + q₂
        H₃ =
          start
            (p' + pot Γ ok) + q + q₂        ≡⟨ step₀ ⟩'
            (p' + pot Γ ok) + (q + q₂)      ≤⟨ step₁ ⟩
            (p + (q₂ + pot-val resok)) + q' ≡⟨ step₂ ⟩'
            (p + (pot-val resok + q₂)) + q' ≡⟨ step₃ ⟩'
            (p + pot-val resok + q₂) + q'   ≡⟨ step₄ ⟩'
            (p + pot-val resok) + q' + q₂   □

        H₄ : (p' + pot Γ ok) + q ≤ (p + pot-val resok) + q'
        H₄ = p+n≤q+n⇒p≤q q₂ H₃

        step₀ = +-assoc p (pot-val resok) q'
        step₁ = cong (λ a → p + a) (+-comm (pot-val resok) q')
      in start
           p' + pot Γ ok + q        ≤⟨ H₄ ⟩
           (p + pot-val resok) + q' ≡⟨ step₀ ⟩'
           p + (pot-val resok + q') ≡⟨ step₁ ⟩'
           p + (q' + pot-val resok) □
    lowerbound .(Γ₂ ++ Γ₁) Ω ok E V T {.q} {.q'} {p} {p'}
               (of/exg Γ₁ Γ₂ .E .T q q' DS) DE sok =
      start
        p' + pot (Γ₂ ++ Γ₁) ok + q         ≡⟨ step₀ ⟩'
        p' + (pot Γ₂ ok₂ + pot Γ₁ ok₁) + q ≡⟨ step₁ ⟩'
        p' + (pot Γ₁ ok₁ + pot Γ₂ ok₂) + q ≡⟨ step₂ ⟩'
        p' + pot (Γ₁ ++ Γ₂) okexg + q      ≤⟨ IH ⟩
        p + (q' + pot-val resok)           □
        where
          resok = preservation (of/exg Γ₁ Γ₂ E T q q' DS) DE ok sok
          ok₁ : EnvOK Ω Γ₁
          ok₁ = ok-append₂ Γ₂ Γ₁ ok
          ok₂ : EnvOK Ω Γ₂
          ok₂ = ok-append₁ Γ₂ Γ₁ ok
          okexg : EnvOK Ω (Γ₁ ++ Γ₂)
          okexg = ok-exg Γ₂ Γ₁ ok

          IH : p' + pot (Γ₁ ++ Γ₂) okexg + q ≤ p + (q' + pot-val resok)
          IH = lowerbound (Γ₁ ++ Γ₂) Ω okexg E V T DS DE sok

          step₀ = cong (λ a → p' + a + q) (pot-concat Γ₂ Γ₁ ok ok₂ ok₁)
          step₁ = cong (λ a → p' + a + q) (+-comm (pot Γ₂ ok₂) (pot Γ₁ ok₁))
          step₂ = cong (λ a → p' + a + q)
                       (sym (pot-concat Γ₁ Γ₂ okexg ok₁ ok₂))
    lowerbound Γ Ω ok E V T₂ {.q} {.q'} {p} {p'}
               (of/sub .Γ .E T₁ .T₂ q q' sub DS) DE sok =
      start
        p' + pot Γ ok + q         ≤⟨ IH ⟩
        p + (q' + pot-val resok)  ≤⟨ step₀ ⟩
        p + (q' + pot-val resok') □
        where
          resok = preservation DS DE ok sok
          resok' = preservation (of/sub Γ E T₁ T₂ q q' sub DS) DE ok sok
          IH = lowerbound Γ Ω ok E V T₁ DS DE sok

          H₀ : q' + pot-val resok ≤ q' + pot-val resok'
          H₀ = p≤q⇒n+p≤n+q q' (pot-sub resok resok' sub)
          step₀ = p≤q⇒n+p≤n+q p H₀
    lowerbound .((v , T₁) ∷ Γ) Ω (ok/cons {.(Ω v)} refl vokh₁ okt)
               E V T₃ {.q} {.q'} {p} {p'}
               (of/sup v Γ .E T₁ T₂ .T₃ q q' sup DS) DE sok =
      start
        p' + (pot-val vokh₁ + pot Γ okt) + q ≤⟨ step₀ ⟩
        p' + (pot-val vokh₂ + pot Γ okt) + q ≤⟨ IH ⟩
        p + (q' + pot-val resok)             □
        where
          resok = preservation (of/sup v Γ E T₁ T₂ T₃ q q' sup DS)
                               DE
                               (ok/cons {(Ω v)} refl vokh₁ okt)
                               sok
          vokh₂ = ok-sub sup vokh₁
          IH = lowerbound ((v , T₂) ∷ Γ) Ω (ok/cons refl vokh₂ okt) E V T₃ DS DE sok

          H₀ : pot-val vokh₁ + pot Γ okt ≤ pot-val vokh₂ + pot Γ okt
          H₀ = n≤m⇒n+k≤m+k (pot-val vokh₁) (pot-val vokh₂)
                           (pot Γ okt) (pot-sub vokh₁ vokh₂ sup)
          H₁ : p' + (pot-val vokh₁ + pot Γ okt) ≤ p' + (pot-val vokh₂ + pot Γ okt)
          H₁ = p≤q⇒n+p≤n+q p' H₀

          step₀ = n≤m⇒n+k≤m+k (p' + (pot-val vokh₁ + pot Γ okt))
                              (p' + (pot-val vokh₂ + pot Γ okt)) q H₁

    soundness : ∀ (Γ : Ctx)(Ω : Env)(ok : EnvOK Ω Γ)
                  (E : Exp)(V : Val)(T : Tp)(q q' : ℕ){p p' : ℕ}
                  (DS : Γ ⊢ E ∶ T ↓〈 q , q' 〉)
                  (DE : Ω ⊢ E ⇓ V ∣〈 p , p' 〉)
                  (sok : SigOK Δ)
                → ∀(k r : ℕ)
                  → k + (q' + pot-val (preservation DS DE ok sok)) < q + pot Γ ok + r
                  → ¬ Σ ℕ (λ k' → Ω ⊢ E ⇓ V ∣〈 k , k' 〉 × r ≤ k')
    soundness Γ Ω ok E V T q q' DS DE sok k r x (k' , DE' , le) =
      let
        vok = preservation DS DE ok sok
        vok' = preservation DS DE' ok sok

        H₀ : k' + pot Γ ok + q ≤ k + (q' + pot-val vok')
        H₀ = lowerbound Γ Ω ok E V T DS DE' sok

        H₁ : k' + pot Γ ok + q + (1 + (k + (q' + pot-val vok))) ≤
             k + (q' + pot-val vok') + (q + pot Γ ok + r)
        H₁ = le-add H₀ x

        -- Subtract out common terms.
        step₀ = +-assoc (k' + pot Γ ok + q + (1 + k)) q' (pot-val vok)
        step₁ = +-assoc (k' + pot Γ ok + q) (1 + k) (q' + pot-val vok)
        step₂ = cong (λ a → k' + pot Γ ok + q + a) (+-assoc 1 k (q' + pot-val vok))
        step₃ = +-assoc-comm k (q' + pot-val vok') (q + pot Γ ok + r)
        step₄ = sym (+-assoc (k + (q + pot Γ ok + r)) q' (pot-val vok'))
        step₅ = cong (λ a → k + (q + pot Γ ok + r) + q' + a) (pot-val-eq vok' vok refl)
        H₂ : k' + pot Γ ok + q + (1 + k) + q' + pot-val vok ≤
             k + (q + pot Γ ok + r) + q' + pot-val vok
        H₂ =
          start
            k' + pot Γ ok + q + (1 + k) + q' + pot-val vok     ≡⟨ step₀ ⟩'
            k' + pot Γ ok + q + (1 + k) + (q' + pot-val vok)   ≡⟨ step₁ ⟩'
            k' + pot Γ ok + q + ((1 + k) + (q' + pot-val vok)) ≡⟨ step₂ ⟩'
            k' + pot Γ ok + q + (1 + (k + (q' + pot-val vok))) ≤⟨ H₁ ⟩
            k + (q' + pot-val vok') + (q + pot Γ ok + r)       ≡⟨ step₃ ⟩'
            k + (q + pot Γ ok + r) + (q' + pot-val vok')       ≡⟨ step₄ ⟩'
            k + (q + pot Γ ok + r) + q' + pot-val vok'         ≡⟨ step₅ ⟩'
            k + (q + pot Γ ok + r) + q' + pot-val vok          □

        H₃ : k' + pot Γ ok + q + (1 + k) + q' ≤ k + (q + pot Γ ok + r) + q'
        H₃ = p+n≤q+n⇒p≤q (pot-val vok) H₂

        H₄ : k' + pot Γ ok + q + (1 + k) ≤ k + (q + pot Γ ok + r)
        H₄ = p+n≤q+n⇒p≤q q' H₃

        step₀ = +-assoc (k' + pot Γ ok + q) 1 k
        step₁ = +-comm k (q + pot Γ ok + r)
        H₅ : k' + pot Γ ok + q + 1 + k ≤ (q + pot Γ ok + r) + k
        H₅ =
          start
            k' + pot Γ ok + q + 1 + k   ≡⟨ step₀ ⟩'
            k' + pot Γ ok + q + (1 + k) ≤⟨ H₄ ⟩
            k + (q + pot Γ ok + r)      ≡⟨ step₁ ⟩'
           (q + pot Γ ok + r) + k       □

        H₆ : k' + pot Γ ok + q + 1 ≤ q + pot Γ ok + r
        H₆ = p+n≤q+n⇒p≤q k H₅

        step₀ = cong (λ a → a + q) (+-assoc-comm k' 1 (pot Γ ok))
        step₁ = +-assoc-comm (k' + pot Γ ok) 1 q
        step₂ = cong (λ a → a + r) (+-comm q (pot Γ ok))
        step₃ = +-assoc-comm (pot Γ ok) q r
        step₄ = cong (λ a → a + q) (+-comm (pot Γ ok) r)
        H₇ : k' + 1 + pot Γ ok + q ≤ r + pot Γ ok + q
        H₇ =
          start
            k' + 1 + pot Γ ok + q ≡⟨ step₀ ⟩'
            k' + pot Γ ok + 1 + q ≡⟨ step₁ ⟩'
            k' + pot Γ ok + q + 1 ≤⟨ H₆ ⟩
            q + pot Γ ok + r      ≡⟨ step₂ ⟩'
            pot Γ ok + q + r      ≡⟨ step₃ ⟩'
            pot Γ ok + r + q      ≡⟨ step₄ ⟩'
            r + pot Γ ok + q      □

        H₈ : k' + 1  + pot Γ ok ≤ r + pot Γ ok
        H₈ = p+n≤q+n⇒p≤q q H₇

        H₉ : k' + 1 ≤ r
        H₉ = p+n≤q+n⇒p≤q (pot Γ ok) H₈

        J₀ : k' < r
        J₀ = start
          1 + k' ≡⟨ +-comm 1 k' ⟩'
          k' + 1 ≤⟨ H₉ ⟩
          r      □

        J₁ : k' < k'
        J₁ = start
           1 + k' ≤⟨ J₀ ⟩
           r      ≤⟨ le ⟩
           k'     □
      in 1+n≰n J₁
