-- Author: Mario Dehesa Azuara (mdehazu@gmail.com)

open import Data.Empty using (⊥;⊥-elim)
open import Data.Nat using (ℕ;_≤_;_+_;_≤′_;_≤″_;less-than-or-equal;z≤n;s≤s)
open import Data.Nat.Properties.Simple using (+-comm;+-assoc;+-right-identity)
open import Data.Nat.Properties using (≤″⇒≤;≤⇒≤″;m≢1+m+n;m≤m+n)

import Data.Nat as Nat
open Nat.≤-Reasoning
  renaming (begin_ to start_; _∎ to _□; _≡⟨_⟩_ to _≡⟨_⟩'_)

import Relation.Binary.PropositionalEquality as PropEq
open PropEq using (_≡_;refl;subst₂;cong;sym;trans)
open PropEq.≡-Reasoning

module NatUtil where
    ≡⇒≤ : ∀ (n m : ℕ) → n ≡ m → n ≤ m
    ≡⇒≤ n m x =
      let
        H : 0 + n ≡ m
        H = subst₂ _≡_ refl refl x

        H' : n + 0 ≡ m
        H' = subst₂ _≡_ (+-comm 0 n) refl H

        H'' : n ≤″ m
        H'' = less-than-or-equal H'
      in ≤″⇒≤  H''

    n≡m⇒n+k≡m+k : ∀ (n m : ℕ) (k : ℕ) → n ≡ m → n + k ≡ m + k
    n≡m⇒n+k≡m+k n m k eq = cong (λ x → x + k) eq

    n≤″m⇒n+k≤″m+k : ∀ (n m : ℕ) (k : ℕ) → n ≤″ m → n + k ≤″ m + k
    n≤″m⇒n+k≤″m+k n m k (less-than-or-equal {f} eq) =
      let
        H₀ : (n + f) + k ≡ m + k
        H₀ = n≡m⇒n+k≡m+k (n + f) m k eq

        H₁ : n + (f + k) ≡ m + k
        H₁ = subst₂ _≡_ (+-assoc n f k) refl H₀

        H₂ : n + (f + k) ≡ n + (k + f)
        H₂ = cong (λ x → n + x) (+-comm f k)

        H₃ : n + (k + f) ≡ m + k
        H₃ = subst₂ _≡_ H₂ H₁ refl

        H₄ : n + (k + f) ≡ (n + k) + f
        H₄ = sym (+-assoc n k f)

        H₅ : (n + k) + f ≡ m + k
        H₅ = subst₂ _≡_ H₄ refl H₃
      in less-than-or-equal H₅

    n≤m⇒n+k≤m+k : ∀ (n m k : ℕ) → n ≤ m → n + k ≤ m + k
    n≤m⇒n+k≤m+k n m k le = ≤″⇒≤ (n≤″m⇒n+k≤″m+k n m k (≤⇒≤″ le))


    +-assoc-comm : ∀ (n m k : ℕ) → (n + m) + k ≡ (n + k) + m
    +-assoc-comm n m k = begin
        (n + m) + k     ≡⟨ +-assoc n m k ⟩
         n + (m + k)    ≡⟨ cong (λ x → n + x) (+-comm m k) ⟩
         n + (k + m)    ≡⟨ sym (+-assoc n k m) ⟩
        (n + k) + m     ∎

    n≤m⇒n≤k+m : ∀ {n m k : ℕ}
                → n ≤ m
                → n ≤ k + m
    n≤m⇒n≤k+m z≤n = z≤n
    n≤m⇒n≤k+m {Nat.suc n} {Nat.suc m} {k} (s≤s x) =
      let
        IH : n ≤ k + m
        IH = n≤m⇒n≤k+m {n} {m} {k} x

        H₀ = start
          Nat.suc n       ≤⟨ s≤s IH ⟩
          (1 + k) + m     ≡⟨ +-assoc-comm 1 k m ⟩'
          (1 + m) + k     ≡⟨ +-comm (1 + m) k ⟩'
          k + (1 + m)     □
      in H₀

    +-comm-l : ∀ (n m k : ℕ) → (n + m) + k ≡ (m + n) + k
    +-comm-l n m k = cong (λ x → x + k) (+-comm n m)

    +-comm-r : ∀ (n m k : ℕ) → n + (m + k) ≡ n + (k + m)
    +-comm-r n m k = cong (λ x → n + x) (+-comm m k)

    p≤″q⇒n+p≤″n+q : ∀ (p q n : ℕ) → p ≤″ q → n + p ≤″ n + q
    p≤″q⇒n+p≤″n+q p q n (less-than-or-equal {f} eq) =
      less-than-or-equal
        (begin
           (n + p) + f  ≡⟨ +-assoc n p f ⟩
            n + (p + f) ≡⟨ cong (λ y → n + y) eq ⟩
            n + q       ∎)

    p≤q⇒n+p≤n+q : ∀ {p q : ℕ} (n : ℕ) → p ≤ q → n + p ≤ n + q
    p≤q⇒n+p≤n+q {p} {q} n L = ≤″⇒≤ (p≤″q⇒n+p≤″n+q p q n (≤⇒≤″ L))

    p≤q⇒p+n≤q+n : ∀ {p q : ℕ} (n : ℕ) → p ≤ q → p + n ≤ q + n
    p≤q⇒p+n≤q+n {p} {q} n L =
      start
        p + n ≡⟨ +-comm p n ⟩'
        n + p ≤⟨ ≤″⇒≤ (p≤″q⇒n+p≤″n+q p q n (≤⇒≤″ L)) ⟩
        n + q ≡⟨ +-comm n q ⟩'
        q + n □

    1+n≡1+m⇒n≡m : ∀ (n m : ℕ) → Nat.suc n  ≡ Nat.suc m  → n ≡ m
    1+n≡1+m⇒n≡m Nat.zero Nat.zero eq = refl
    1+n≡1+m⇒n≡m Nat.zero (Nat.suc m) ()
    1+n≡1+m⇒n≡m (Nat.suc n) .(Nat.suc n) refl = refl

    n+m≡n+k⇒m≡k : ∀ (n m k : ℕ) → n + m ≡ n + k → m ≡ k
    n+m≡n+k⇒m≡k Nat.zero m k eq = eq
    n+m≡n+k⇒m≡k (Nat.suc n) m k eq =
      let
        H : n + m ≡ n + k
        H = 1+n≡1+m⇒n≡m (n + m) (n + k) eq
      in n+m≡n+k⇒m≡k n m k H

    p+n≤q+n⇒p≤q : ∀ {p q : ℕ}(n : ℕ) → p + n ≤ q + n → p ≤ q
    p+n≤q+n⇒p≤q {p} {q} n le =
      let
        less-than-or-equal {f} eq = ≤⇒≤″ le

        H₀ : n + (p + f)  ≡ n + q
        H₀ = begin
          n + (p + f) ≡⟨ +-comm n (p + f) ⟩
          (p + f) + n ≡⟨ +-assoc-comm p f n ⟩
          p + n + f   ≡⟨ eq ⟩
          q + n       ≡⟨ +-comm q n ⟩
          n + q       ∎

        H₁ : p + f ≡ q
        H₁ = n+m≡n+k⇒m≡k n (p + f) q H₀

      in  ≤″⇒≤ (less-than-or-equal H₁)

    le-add : ∀ {n₁ n₂ m₁ m₂ : ℕ}
               (le₁ : n₁ ≤ n₂)
               (le₂ : m₁ ≤ m₂)
             → n₁ + m₁ ≤ n₂ + m₂
    le-add Nat.z≤n Nat.z≤n = z≤n
    le-add (Nat.z≤n {k}) (Nat.s≤s {n} {m} le) =
      n≤m⇒n≤k+m {Nat.suc n} {Nat.suc m} {k} (s≤s le)
    le-add (Nat.s≤s le) le₂ = Nat.s≤s (le-add le le₂)

    -- Misc Rearrangements
    rearrange-eq₁ : ∀ (k q z f q' j b : ℕ)
                    → k ≡ z + b + q + f
                    → q ≡ q' + j
                    → k ≡ z + b + f + q' + j
    rearrange-eq₁ k q z f q' j b eq₀ eq₁ =
      begin
        k                              ≡⟨ eq₀ ⟩
        (z + b + q) + f                ≡⟨ +-assoc-comm (z + b) q f ⟩
        (z + b + f) + q                ≡⟨ cong (λ y → z + b + f + y) eq₁ ⟩
        z + b + f + (q' + j)           ≡⟨ sym (+-assoc (z + b + f) q' j) ⟩
        z + b + f + q' + j             ∎

    rearrange-eq₂ : ∀ (n a b c d e : ℕ)
                    → n + a + b + c + (d + e) ≡ n + (a + d) + b + c + e
    rearrange-eq₂ n a b c d e =
      begin
        n + a + b + c + (d + e) ≡⟨ sym (+-assoc (n + a + b + c) d e) ⟩
        n + a + b + c + d + e   ≡⟨ cong (λ x → x + e) (+-assoc-comm (n + a + b) c d) ⟩
        n + a + b + d + c + e   ≡⟨ cong (λ x → x + c + e) (+-assoc-comm (n + a) b d) ⟩
        n + a + d + b + c + e   ≡⟨ cong (λ x → x + b + c + e) (+-assoc n a d) ⟩
        n + (a + d) + b + c + e ∎

    rearrange-eq₃ : ∀ (a b c d e : ℕ)
                    → a + (b + c) + d + e ≡ a + c + e + (b + d)
    rearrange-eq₃ a b c d e =
      begin
        a + (b + c) + d + e ≡⟨ cong (λ x → a + x + d + e) (+-comm b c) ⟩
        a + (c + b) + d + e ≡⟨ cong (λ x → x + d + e) (sym (+-assoc a c b)) ⟩
        a + c + b + d + e   ≡⟨ +-assoc-comm (a + c + b) d e ⟩
        a + c + b + e + d   ≡⟨ cong (λ x → x + d) (+-assoc-comm (a + c) b e) ⟩
        a + c + e + b + d   ≡⟨ +-assoc (a + c + e) b d ⟩
        a + c + e + (b + d) ∎

    rearrange-eq₄ : ∀ (a b c d : ℕ)
                    → a + b + c + d ≡ a + (b + d) + c
    rearrange-eq₄ a b c d =
      begin
        a + b + c + d   ≡⟨ +-assoc-comm (a + b) c d ⟩
        a + b + d + c   ≡⟨ cong (λ x → x + c) (+-assoc a b d) ⟩
        a + (b + d) + c ∎

    rearrange-eq₅ : ∀ (a b c d e f : ℕ)
                    → (a + (b + c) + d) + (e + f) ≡ (a + (b + f + c) + d) + e
    rearrange-eq₅ a b c d e f =
      begin
        (a + (b + c) + d) + (e + f) ≡⟨ cong (λ x → (a + (b + c) + d) + x) (+-comm e f) ⟩
        (a + (b + c) + d) + (f + e) ≡⟨ sym (+-assoc (a + (b + c) + d) f e) ⟩
        (a + (b + c) + d) + f + e   ≡⟨ cong (λ x → x + e) (+-assoc-comm (a + (b + c)) d f) ⟩
        (a + (b + c) + f) + d + e   ≡⟨ cong (λ x → x + d + e) (+-assoc a (b + c) f) ⟩
        a + (b + c + f) + d + e    ≡⟨ cong (λ x → a + x + d + e) (+-assoc-comm b c f) ⟩
        a + (b + f + c) + d + e    ∎

    rearrange-le₁ : ∀ (z j q' f : ℕ)
                    → (z + j) + q' ≤ z + j + f + q'
    rearrange-le₁ z j q' f =
      start
        (z + j) + q'              ≤⟨ m≤m+n (z + j + q') f ⟩
        (z + j + q') + f          ≡⟨ +-assoc-comm (z + j) q' f ⟩'
        (z + j + f) + q'          □

    nat-eq-inv : ∀ {n m : ℕ}
                 → Nat.suc n ≡ Nat.suc m
                 → n ≡ m
    nat-eq-inv {n} {.n} refl = refl


    suc-eq-zero : ∀ (n : ℕ)
                  → Nat.suc n ≡ 0
                  → ⊥
    suc-eq-zero n ()

    id-left-unique : ∀ (n k : ℕ)
                 → n ≡ k + n
                 → k ≡ 0
    id-left-unique n Nat.zero refl = refl
    id-left-unique Nat.zero (Nat.suc k) ()
    id-left-unique (Nat.suc n) (Nat.suc k) x =
      let
        H₀ = begin
         n           ≡⟨ nat-eq-inv x ⟩
         k + (1 + n) ≡⟨ sym (+-assoc k 1 n) ⟩
         (k + 1) + n ≡⟨ cong (λ a → a + n) (+-comm k 1) ⟩
         (1 + k) + n ∎

        H₁ = id-left-unique n (1 + k) H₀
      in ⊥-elim (suc-eq-zero k H₁)
