-- Author: Mario Dehesa Azuara (mdehazu@gmail.com)

module Context where

open import Syntax

open import Relation.Binary
  using (Setoid; Rel; Reflexive; Symmetric; Transitive; IsEquivalence)
open import Relation.Binary.PropositionalEquality using (_≡_; refl; sym; trans)

open import Relation.Nullary using (¬_)

open import Level using (suc ; zero)
open import Data.Product using (_×_ ; _,_; proj₁; proj₂) public

private
    _≈_ : Rel (Var × Tp) zero
    (n₁ , T₁) ≈ (n₂ , T₂) = (n₁ ≡ n₂) × (T₁ ≡ T₂)

    isRefl : Reflexive _≈_
    isRefl = (refl , refl)

    isSymm : Symmetric _≈_
    isSymm x = (sym (proj₁ x) , sym (proj₂ x))

    isTrans : Transitive _≈_
    proj₁ (isTrans ij jk) = trans (proj₁ ij) (proj₁ jk)
    proj₂ (isTrans ij jk) = trans (proj₂ ij) (proj₂ jk)

    isEquiv : IsEquivalence _≈_
    isEquiv = record
      { refl = isRefl
      ; sym = isSymm
      ; trans = isTrans
      }

    VT : Setoid zero zero
    VT = record
      { Carrier = Var × Tp
      ; _≈_ = _≈_
      ; isEquivalence = isEquiv
      }

import Data.List.Any as Any
open Any using (here;there) public
open Any.Membership(VT) using (_∈_;_∉_) public
open import Data.List using (List;_∷_;_++_) renaming ([] to ∅) public

Ctx : Set
Ctx = List (Var × Tp)

fresh : Var → Ctx → Set
fresh v Γ = ∀ (T : Tp) → (v , T) ∉ Γ


fresh-wkn : ∀ {x v : Var}{T : Tp}{Γ : Ctx}
            → fresh x ((v , T) ∷ Γ)
            → fresh x Γ
fresh-wkn DF T₁ mem = DF T₁ (there mem)

fresh-++₂ : ∀ (x : Var)(Γ₁ Γ₂ : Ctx)
           → fresh x (Γ₁ ++ Γ₂)
           → fresh x Γ₂
fresh-++₂ x ∅ Γ₂ DF = DF
fresh-++₂ x ((v , T) ∷ Γ₁) Γ₂ DF = fresh-++₂ x Γ₁ Γ₂ (fresh-wkn DF)
