-- Author: Mario Dehesa Azuara (mdehazu@gmail.com)

open import Syntax
open import Context
open import Environment

open import Relation.Binary.PropositionalEquality using (_≡_)
open import Data.Product using (_×_; _,_; Σ; proj₁; proj₂)
open import Data.List using
        (List; _++_; _∷_) renaming ([] to ∅)
open import Data.Nat using (ℕ;_+_)



module BigStep (metric : Oper → ℕ)(Δ : Sig) where
    data _⊢_⇓_∣〈_,_〉 : ∀ (Ω : Env)(E : Exp)(E' : Val)(q q' : ℕ) → Set where
         step/var   : ∀ (Ω : Env)(v : Var)(V : Σ Val (λ V' → V' ≡ Ω(v)))(q q' : ℕ)
                      → q ≡ q' + (metric var)
                      → Ω ⊢ var v ⇓ (proj₁ V) ∣〈 q , q' 〉

         step/true  : ∀ (Ω : Env)(q q' : ℕ)
                      → q ≡ q' + (metric true)
                      → Ω ⊢ true ⇓ true ∣〈 q , q' 〉

         step/false : ∀ (Ω : Env)(q q' : ℕ)
                      → q ≡ q' + (metric false)
                      → Ω ⊢ false ⇓ false ∣〈 q , q' 〉

         step/if₁   : ∀ (Ω : Env)(v : Var)(E₁ E₂ : Exp)(V : Val)(q₁ q q' : ℕ)
                      → Ω(v) ≡ true
                      → Ω ⊢ E₁ ⇓ V ∣〈 q₁ , q' 〉
                      → q ≡ q₁ + (metric if₁)
                      → Ω ⊢ if v E₁ E₂ ⇓ V ∣〈 q , q' 〉

         step/if₂   : ∀ (Ω : Env)(v : Var)(E₁ E₂ : Exp)(V : Val)(q₂ q q' : ℕ)
                     → Ω(v) ≡ false
                     → Ω ⊢ E₂ ⇓ V ∣〈 q₂ , q' 〉
                     → q ≡ q₂ + (metric if₂)
                     → Ω ⊢ if v E₁ E₂ ⇓ V ∣〈 q , q' 〉

         step/let   : ∀ (Ω : Env)(E₁ E₂ : Exp)(v : Var)(V₁ V₂ : Val)(q₀ q₁ q q' : ℕ)
                      → Ω ⊢ E₁ ⇓ V₁ ∣〈 q₀ , q₁ 〉
                      → (H : Σ Env (λ Ω' → Ω' ≡ (v , V₁ ∣ Ω)))
                      → (proj₁ H) ⊢ E₂ ⇓ V₂ ∣〈 q₁ , q' 〉
                      → q ≡ q₀ + (metric elet)
                      → Ω ⊢ elet E₁ (v , E₂) ⇓ V₂ ∣〈 q , q' 〉

         step/nil : ∀ (Ω : Env)(q q' : ℕ)
                    → q ≡ q' + metric nil
                    → Ω ⊢ nil ⇓ nil ∣〈 q , q' 〉

         step/cons : ∀ (Ω : Env)(v₁ v₂ : Var)(q q' : ℕ)
                     → q ≡ q' + metric cons
                     → (V : Σ Val (λ v → v ≡ Ω(v₁)))
                     → (VS : Σ Val (λ vs → vs ≡ Ω(v₂)))
                     → Ω ⊢ cons v₁ v₂ ⇓ cons (proj₁ V) (proj₁ VS) ∣〈 q , q' 〉

         step/matl₁ : ∀ (Ω : Env)(v₀ v₁ v₂ : Var)(E₁ E₂ : Exp)(V : Val)(q₁ q q' : ℕ)
                     → Ω(v₀) ≡ nil
                     → q ≡ q₁ + metric matl₁
                     → Ω ⊢ E₁ ⇓ V ∣〈 q₁ , q' 〉
                     → Ω ⊢ matl v₀ E₁ (v₁ , v₂ , E₂) ⇓ V ∣〈 q , q' 〉

         step/matl₂ : ∀ (Ω : Env)(v₀ x xs : Var)(E₁ E₂ : Exp)
                        (X XS V : Val)(q₂ q q' : ℕ)
                      → Ω(v₀) ≡ cons X XS
                      → (H : Σ Env (λ Ω' → Ω' ≡ (x , X ∣ (xs , XS ∣ Ω))))
                      → (proj₁ H) ⊢ E₂ ⇓ V ∣〈 q₂ , q' 〉
                      → q ≡ q₂ + metric matl₂
                      → Ω ⊢ matl v₀ E₁ (x , xs , E₂) ⇓ V ∣〈 q , q' 〉

         step/share : ∀ (Ω : Env)(x x₁ x₂ : Var)(E : Exp)(V V₁ : Val)(q q' : ℕ)
                      → Ω x ≡ V
                      → (Ω' : Σ Env (λ Ω' → Ω' ≡ (x₁ , V ∣ (x₂ , V ∣ Ω))))
                      → (proj₁ Ω') ⊢ E ⇓ V₁ ∣〈 q , q' 〉
                      → Ω ⊢ share x (x₁ , x₂ , E) ⇓ V₁ ∣〈 q , q' 〉

         step/app : ∀ (Ω : Env)(f : FID)(x₁ x₂ : Var)(V₁ V₂ : Val)
                      (E : Exp)(p p₁ p' : ℕ)(T₁ T₂ : Tp)(q q' : ℕ)
                    → Ω x₁ ≡ V₁
                    → Δ f ≡ ((T₁ , q , q' , T₂) , x₂ , E)
                    → p ≡ p₁ + metric app
                    → (x₂ , V₁ ∣ ◎) ⊢ E ⇓ V₂ ∣〈 p₁ , p' 〉
                    → Ω ⊢ app f x₁ ⇓ V₂ ∣〈 p , p' 〉
