#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <conio.h>
#include <1394camera.h>

int main()
{
	C1394Camera theCamera;
	int ret;

	printf("PYRO Webcam rev 2.1A Framerate Fix\n\n");
	printf("Before continuing, make sure your defective PYRO Webcam is the only camera on the bus\n\n");
	printf("Do you wish to continue (y/n)?");

	ret = getch();

	if(ret != 'y' && ret != 'Y')
	{
		printf("\n\nPYRO Webcam Framerate fix aborted!\n");
		getch();
		return 0;
	}

	printf("\n\nInitializing Camera...\n\n");

	if((ret = theCamera.CheckLink()) != CAM_SUCCESS)
	{
		printf("Error %d on CheckLink\n",ret);
		getch();
		return 0;
	}

	// now apply the fix
	// apparently, on the pyro, the iris feature control is somehow wired to a maximum framerate
	// For rev 2.0A (the first released version as I understand it) this register was wired
	// such that min = max = default = 4, which allowed 30 fps.
	// For rev 2.1A (seems to have been released in mid-lat 2002), this register was set up so that
	// min = 0; max = 3, default = 2, so the rate was capped at 7.5 fps and could be varied between 1.875 and 15

	// here, we set up the 2.1A to match the 2.0A

	// EEPROM write-through is enabled by sending 0x12345678 to 0xf0f00f00
	printf("Enabling EEPROM write-through...");
	if((ret =theCamera.WriteQuadlet(0xf0f00f00,0x12345678)) != CAM_SUCCESS)
	{
		printf("Error %d on WriteQuadlet(0xf0f00f00) (GetLastError -> %d)\n",ret,GetLastError());
		getch();
		return 0;
	}

	// IRIS_INQ is CSR + 0x524.  we want to make it 0x89004004
	printf("OK\nWriting 0x89004004 to the register at 0xf0f00524...");
	if((ret = theCamera.WriteQuadlet(0xf0f00524,0x89004004)) != CAM_SUCCESS)
	{
		printf("Error %d on WriteQuadlet(0xf0f00524) (GetLastError -> %d)\n",ret,GetLastError());
		getch();
		return 0;
	}

	// IRIS_STATUS is CSR + 824.  We want the default to be 0x82000004
	printf("OK\nWriting 0x82000004 to the register at 0xf0f00824...");
	if((ret = theCamera.WriteQuadlet(0xf0f00824,0x82000004)) != CAM_SUCCESS)
	{
		printf("Error %d on WriteQuadlet(0xf0f00524) (GetLastError -> %d)\n",ret,GetLastError());
		getch();
		return 0;
	}

	printf("OK\nDisabling EEPROM write-through...");
	if((ret =theCamera.WriteQuadlet(0xf0f00f00,0x00000000)) != CAM_SUCCESS)
	{
		printf("Error %d on WriteQuadlet(0xf0f00f00) (GetLastError -> %d)\n",ret,GetLastError());
		getch();
		return 0;
	}

	printf("OK\n\nFramerate fix has been applied, your camera should work properly now\n");

	getch();
	return 0;
}