/*
 * ControlDialog.h
 */

#ifndef __CONTROL_DIALOG_H__
#define __CONTROL_DIALOG_H__

#define PIF_TWO_SLIDERS 1
#define PIF_VISIBLE 2

#define MAX_PANES 64

typedef struct _CONTROL_PANE_EXTENSION
{
	long window_id;
	HWND hWndParent;
	long flags;
	long slider_min, slider_max;
	char *pane_name;
	C1394CameraControl *pControl; // the control this pane is monitoring
} CONTROL_PANE_EXTENSION, *PCONTROL_PANE_EXTENSION;

typedef struct _CONTROL_WINDOW_EXTENSION
{
	long nPanes; // how many panes?
	HWND hWndParent;
	long flags;
	long trackpos;
	C1394Camera *pCamera; // the camera that this dialog is controlling
	unsigned char PaneState[MAX_PANES]; 
} CONTROL_WINDOW_EXTENSION, *PCONTROL_WINDOW_EXTENSION;

HWND InitControlDialogInstance(HINSTANCE hInstance, HWND hWndParent, C1394Camera *pCamera);
BOOL ShowControlPanes(HWND hWnd,BOOL bChanged);
BOOL CreatePane(HINSTANCE hInstance, HWND hWndParent, int nIndex);


#endif