//  1394CameraControl.h: interface for the C1394CameraControl class.
//
//	Version 5.2
//
//	Copyright 5/2000
// 
//	Iwan Ulrich
//	Robotics Institute
//	Carnegie Mellon University
//	Pittsburgh, PA
//
//  Copyright 3/2002
//
//  Christopher Baker
//  Robotics Institute
//  Carnegie Mellon University
//  Pittsburgh, PA
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//////////////////////////////////////////////////////////////////////

#ifndef __1394CAMERACONTROL_H__
#define __1394CAMERACONTROL_H__

class C1394Camera;

class CAMAPI C1394CameraControl  
{
friend C1394Camera;

public:
	void TurnOn(BOOL on);
	void SetOnePush();
	void SetAutoMode(BOOL on);
	void GetValues();
	void SetValues();
	void Status();
	void Inquire();
	C1394CameraControl();
	virtual ~C1394CameraControl();

	C1394Camera* m_pCamera;

	// feature inquiry values
	bool m_present;	
	bool m_onePush;
	bool m_readout;
	bool m_onoff;
	bool m_auto;
	bool m_manual;
	int m_min;
	int m_max;

	// status values
	bool m_statusOnePush;
	bool m_statusOnOff;
	bool m_statusAutoManual;
	int m_value1;					// bits 20 to 31
	int m_value2;					// bits 8 to 19

protected:
	// offsets
	int m_offsetInquiry;
	int m_offsetStatus;

	// status values
	unsigned int m_status;			// value read
	unsigned int m_mode;			// bits 0 to 7
};

#endif // __1394CAMERACONTROL_H__
