//  1394CameraControlTrigger.h: interface for the C1394CameraControlTrigger class.
//
//	Version 4.0
//
//	Copyright 5/2000
// 
//	Iwan Ulrich
//	Robotics Institute
//	Carnegie Mellon University
//	Pittsburgh, PA
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//////////////////////////////////////////////////////////////////////

#ifndef __1394CAMERACONTROLTRIGGER_H__
#define __1394CAMERACONTROLTRIGGER_H__

#include "1394CameraControl.h"

class C1394Camera;

class __declspec(dllexport) C1394CameraControlTrigger : public C1394CameraControl  
{
public:
	void SetMode(int mode, int parameter);
	void SetPolarity(bool polarity);
	void Status();
	void TurnOn(bool on);
	void Inquire();
	C1394CameraControlTrigger();
	virtual ~C1394CameraControlTrigger();

	// feature inquiry values
	bool m_polarity;
	bool m_triggerMode[4];
	bool m_statusPolarity;
	int m_statusMode;

protected:	
	void SetValues();
};

#endif // __1394CAMERACONTROLTRIGGER_H__
