#!/usr/bin/perl

package Geckobot::Module::Weather;

$VERSION = "0.01_00";
use strict;

my $anybad;

BEGIN {
  $anybad = 0;
  eval "use LWP::Simple";
  $@ and do { $anybad = "Weather is missing LWP::Simple\n"; print STDERR $anybad; };
}

use Geckobot::Module;
@Geckobot::Module::Weather::ISA = qw(Geckobot::Module);

sub new {
  return undef if $anybad;
  my $class = shift ;
  my $self  = $class->SUPER::new(@_);

  $self->weight(1); 

  $self->name('Weather');
  $self->regex(qr/^weather(?:\s+for)?\s+(.+)\s*$/i);
  $self->usage('weather (for)? <stationcode>');
  $self->descrip("'weather for KAGC' retrieves the weather for from the KAGC weather station. Use any station known by the NOAA web site to get the weather; see http://weather.noaa.gov/weather/curcond.html for locations and codes.");

  $self->{_cache} = {};
  $self->{_cache_time} = 60 * 25 ; # 25-minute cache time

  bless $self, $class;
}

sub action {
    my ($self, $message) = @_;

    my $station = uc($message->{args}->[0]);
    return '' unless $self->enabled;

    my $result;
    my %feat;
    my ($max_temp, $min_temp);
    if (exists $self->{_cache}->{$station}) {
	my ($time, $response) = split $; , $self->{_cache}->{$station};
	if ((time() - $time) < $self->{_cache_time}) {
	    return $response;
	}
    }

    my $content = 
      LWP::Simple::get("http://tgsv7.nws.noaa.gov/weather/current/$station.html");

    if ($content =~  /ERROR/i) {
	return "I can't find that station code (see http://weather.noaa.gov/weather/curcond.html for locations codes)";
    }

    $content =~ s|.*?current weather conditions.*?</TR>||is;

    $content =~ s|.*?<TR>(?:\s*<[^>]+>)*\s*([^<]+)\s<.*?</TR>||is;
    my $place = $1;
    chomp $place;

    $content =~ s|.*?<TR>(?:\s*<[^>]+>)*\s*([^<]+)\s<.*?</TR>||is;
    my $id = $1;
    chomp $id;

    $content =~ s|.*?conditions at.*?</TD>||is;

    $content =~ s|.*?<OPTION SELECTED>\s+([^<]+)\s<OPTION>.*?</TR>||s;
    my $time = $1;
    $time =~ s/-//g;
    $time =~ s/\s+/ /g;

    $content =~ s|\s(.*?)<TD COLSPAN=2>||s;
    my $features = $1;

    while ($features =~ s|.*?<TD ALIGN[^>]*>(?:\s*<[^>]+>)*\s+([^<]+?)\s+<.*?<TD>(?:\s*<[^>]+>)*\s+([^<]+?)\s<.*?/TD>||s) {
	my ($f,$v) = ($1, $2);
	chomp $f; chomp $v;
	$feat{$f} = $v;
    }

    $content =~ s|.*?>(\d+\S+\s+\(\S+\)).*?</TD>||s; # max temp;
    $max_temp = $1;
    $content =~ s|.*?>(\d+\S+\s+\(\S+\)).*?</TD>||s;  
    $min_temp = $1;

    if ($time) {
	$result = "$place; $id; last updated: $time";
	foreach (sort keys %feat) {
	    next if $_ eq 'ob';
	    $result .= "; $_: $feat{$_}";
	}
	my $t = time();
	$self->{_cache}->{$station} = join $;, $t, $result;
    } else {
	$result = "I can't find that station code (see http://weather.noaa.gov/weather/curcond.html for locations and codes)";
    }

    return $result;
}

1;
