#!/usr/bin/perl

package Geckobot::Module::W3Search;

$VERSION = "0.01_00";
use strict;

my $anybad;

BEGIN {
    $anybad = '';
    eval { require LWP::Simple };
    $@ and $anybad = "LWP::Simple"; 
    eval { require WWW::Search };
    $@ and do { $anybad .= ", " if $anybad; $anybad .= "WWW::Search"};
    eval { require WWW::Search::Google };
    $@ and do { $anybad .= ", " if $anybad; $anybad .= "WWW::Search::Google"};
    $anybad = "W3Search is missing $anybad\n" if $anybad;
    print STDERR $anybad if $anybad;
}

use Geckobot::Module;
@Geckobot::Module::W3Search::ISA = qw(Geckobot::Module);

my @engines = qw(AltaVista Dejanews Excite Gopher HotBot Infoseek 
		     Lycos Magellan PLweb SFgate Simple Verity Google);
my $w3regex = join '|', @engines;

sub new {
  return undef if $anybad;

  my $class = shift ;
  my $self  = $class->SUPER::new(@_);

  $self->weight(1); 

  $self->name('W3Search');
  $self->regex(qr/^\s*(?:search\s+)?($w3regex)\s+for\s+(.*)/i);
  $self->usage('W3Search <engine> (for)? <keywords>');
  $self->descrip("'search google for foo' goes and gets the top few URLs from http://www.google.com for the query 'foo'.");

  $self->{_cache} = {};
  $self->{_cache_time} = 60 * 25 ; # 25-minute cache time

  bless $self, $class;
}

sub action {
    my $self = shift ;
    
    return '' unless $self->enabled;

    my ($message) = shift; 
    my ($where, $what) = @{$message->{args}};

    my @matches = grep { lc($_) eq lc($where) ? $_ : undef } @engines;

    if (!@matches) {
	return "i don't know how to check '$where'";
    } else {
	$where = shift @matches;
    }

    my $Search = new WWW::Search($where);
    my $Query = WWW::Search::escape_query($what);
    $Search->native_query($Query); 

    my ($Result, $r, $count);
    while ($r = $Search->next_result()) {
	if ($Result) {
	    $Result .= " or ".$r->url();
	} else {
	    $Result = $r->url();
	}
	last if ++$count >= 3;
    }

    if ($Result) {
	return "$where says $what is $Result";
    } else {
	return "$where can't find $what";
    }
}

1;

