#!/usr/bin/perl
package Geckobot::Module::ModuleMgr;

$VERSION = "0.01_00";
use strict;

my $anybad;

BEGIN {
  $anybad = 0;
  eval "use LWP::Simple";
  $@ and do { $anybad = "ModuleMgr is missing LWP::Simple\n"; print STDERR $anybad; };
}

use Geckobot::Module;
@Geckobot::Module::ModuleMgr::ISA = qw(Geckobot::Module);

sub new {
  return undef if $anybad;
  my $class = shift ;
  my $self  = $class->SUPER::new(@_);

  $self->name('ModuleMgr');
  $self->regex(qr/^(modules|set (\S+) (\S+) (.*))$/i);
  bless $self, $class;

}

sub matches {
  my $self = shift ;
  my $message = shift ;

  my $text = $message->{text};
  return 1 if $text =~ /^modules$/i;
  
  if ($text =~ s/^set (\S+) (\S+)\s*(.*?)\s*$//i) {
    my ($name, $key, $value) = ($1, $2, $3);
    $value = 1 if length($value) < 1;

    if ($name =~ /^param(eter)?$/i) {
      # 'set param <k> <v>' affects the bots params
      my $was = $self->{bot}->{param}->{$key};
      $message->{done} = "$key = $value [was $was]";
      $self->{bot}->{param}->{$key} = $value;
      return 1;
    } else {
      # otherwise, we're presuming to talk about 
      # a module. this should be cleaned up to
      # only allow attributes set through legit
      # methods.
      $name = lc($name);
      my ($module, $which);
      foreach $module (@{$self->{bot}->{modules}}) {
	if (lc($module->name) eq $name) {
	  $which = $module;
	  last ;
	}
      }
      if ($which) {
	my $was;
	$was = $which->{$key} if defined $which->{$key};
	$was = 'undef' unless $was;
	$message->{done} = $which->name()." $key = $value [was $was]";
	$which->{$key} = $value;
	return 1;
      }
    }
  }
}

sub action {
  my ($self, $message) = @_;
  my $reply = '';

  return $message->{done} if defined $message->{done};

  foreach (keys %{$self->{bot}}) {
    next if ref $self->{bot}->{$_};
    $reply .= "$_ => $self->{bot}->{$_}\n";
  }

  $reply .= "parameters: ";
  foreach (sort keys %{$self->{bot}->{param}}) {
    $reply .= "$_ => $self->{bot}->{param}->{$_}; ";
  }
  $reply =~ s/; $/\n/;

  $reply .= "modules: ";
  foreach my $module (@{$self->{bot}->{modules}}) {
    if ($module->enabled) {
      $reply .= '+';
    } else {
      $reply .= '-';
    }
    my $v = $module->VERSION;
    $v =~ s/_.*//;
    $reply .= $module->name . ' ' . $v . '; ';
  }
  $reply =~ s/; $/\n/;

  $reply .= "clients: ";
  foreach my $client (@{$self->{bot}->{clients}}) {
    $reply .= $client->{protocol} . '; ';
  }

  $reply =~ s/; $//;
  return $reply;
}

1;
