#!/usr/bin/perl

package Geckobot::Module::METAR;

$VERSION = "0.01_00";
use strict; 

my $anybad;

BEGIN {
    $anybad = '';
    eval { require Geo::METAR };
    $@ and $anybad = "LWP::Simple"; 
    eval { require LWP::UserAgent };
    $@ and do { $anybad .= ", " if $anybad; $anybad .= "LWP::UserAgent"};
    eval { require LWP::Simple };
    $@ and do { $anybad .= ", " if $anybad; $anybad .= "LWP::Simple"};
    eval { require HTTP::Request };
    $@ and do { $anybad .= ", " if $anybad; $anybad .= "HTTP::Request"};
    $anybad = "METAR is missing $anybad\n" if $anybad;
    print STDERR $anybad if $anybad;
}

use Geckobot::Module;
@Geckobot::Module::METAR::ISA = qw(Geckobot::Module);

sub new {
  return undef if $anybad;
  my $class = shift ;
  my $self  = $class->SUPER::new(@_);

  $self->weight(1); 

  $self->name('METAR');
  $self->regex(qr/^metar(?:\s+for)?\s+(\S{4,5})\s*$/i);
  $self->usage('METAR (for)? <station>');
  $self->descrip("'metar for KPIT' goes and gets the METAR information from the NOAA web site.");

  $self->{_cache} = {};
  $self->{_cache_time} = 60 * 25 ; # 25-minute cache time

  bless $self, $class;
}

sub action {
    my $self = shift ;

    return '' unless $self->enabled;
    my $message = shift ;
    my $station = $message->{args}->[0];

    return '' unless $station;

    my $site_id = uc($station);
    if ($site_id !~ /^[A-Z]{4,5}$/) {
	return "$site_id doesn't look like a valid METAR code";
    }

    # METAR web-resource.
    my $metar_url = "http://weather.noaa.gov/cgi-bin/mgetmetar.pl?cccc=";

    # Grab METAR report from Web.   
    my $agent = new LWP::UserAgent;
    my $grab = new HTTP::Request GET => $metar_url . $site_id;

    my $reply = $agent->request($grab);
    
    # If it can't find it, assume luser error :-)
    if (!$reply->is_success) {
        return "$site_id doesn't seem to exist; try a 4-letter station code (like KAGC)";
    }  
    
    # extract METAR from incredibly and painfully verbose webpage
    my $webdata = $reply->as_string;
    $webdata =~ m/($site_id\s\d+Z.*?)</s;    
    my $metar = $1;                       
     
    # Sane?
    return "Data for $site_id not available, try later." if length($metar) < 10;
    
    # Process raw METAR data
    my $report = new Geo::METAR;
    $report->debug(0);
    $report->metar($metar);
    
    # Generate response. Messy as hell, but it works. :-)
    # Don't rely on Geo::METAR docs for variable names. It's not
    # even close in some cases.
    #
    # oh, and talk about annoying:
    #        } elsif ($tok =~ /K[A-Z]{3,3}/) {
    #          $self->{site} = $tok;
    # the WORLD is NOT the UNITED STATES. We can't rely on $foo->{site},
    # since it only grabs American (K-prefix) SITE_IDs.

    my $response = "$report->{TYPE} ";
    $response .= "($report->{MOD}) " if $report->MOD;
    $response .= "for $site_id at $report->{DATE} $report->{TIME}: Winds $report->{WIND_KTS} ";

    $response .= "to $report->{WIND_KTS_GUST} " if $report->WIND_KTS_GUST;

    $response .= "at $report->{WIND_DIR_DEG} ($report->{WIND_DIR_ENG}). Temp $report->{C_TEMP}C/$report->{F_TEMP}F and dewpoint $report->{C_DEW}C/$report->{F_DEW}F. Visibility $report->{visibility}. Weather conditions ";

    $response .= join(' ', @{$report->{weather}}) ? join(' ', @{$report->{weather}}) : "not available";  # Most METAR puts this in 'conditions' ({sky}).
   
    $response .= ". Altimeter ";
    $response .= $report->{alt} ? "$report->{alt}. " : "not available. ";

    $response .= "Cloud ";
    $response .= join(' ', @{$report->{sky}});

    $response .= ". Have a nice flight.";   # :-)

    return $response;
}

1;
