#!/usr/bin/perl

package Geckobot::Module::Babelfish;

$VERSION = "0.01_00";
use strict;

my $anybad;

BEGIN {
  $anybad = '';
  eval { require LWP::Simple };
  $@ and $anybad = "LWP::Simple"; 
  eval "use URI::Escape";   
  $@ and do { $anybad .= ", " if $anybad; $anybad .= "UWI::Escape"};

  # Translate some feasible abbreviations into the ones babelfish
  # expects.
  use vars qw!%lang_code $langregex!;
  %lang_code = (
		fr => 'fr',
		sp => 'es',
		po => 'pt',
		pt => 'pt',
		it => 'it',
		ge => 'de',
		de => 'de',
		gr => 'de',
		en => 'en',
		french => 'fr',
		spanish => 'es',
		german => 'de',
		italian => 'it'
		);

  # Here's how we recognize the language you're asking for.  It looks
  # like RTSL saves you a few keystrokes in #perl, huh?
  $langregex = join '|', keys %lang_code;
}

use Geckobot::Module;
@Geckobot::Module::Babelfish::ISA = qw(Geckobot::Module);

sub Geckobot::Module::Babelfish::new {
  return undef if $anybad;

  my $class = shift ;
  my $self  = $class->SUPER::new(@_);

  $self->weight(1); 

  $self->name('Babelfish');
  $self->regex(qr/^\s*(?:(?:x|trans(?:late))\s+(in|to|from)\s+($langregex)\s+(.*))|(?:(.*?)\s+(in|to|from)\s+($langregex)\s*$)/ix);
  $self->usage("(x|trans(late)?) (to|from) ($langregex) /.*/   or  /.*?/ (in|to|from) ($langregex)");
  $self->descrip('translates english to (or from) the language that Babelfish supports, using Babelfish.');

  bless $self, $class;
}

sub action {
  my $self = shift;
  return undef unless $self->enabled;

  my $message = shift ;
  my @args = @{$message->{args}};

  # handle the two possible argument formats
  
  my ($direction, $lang, $phrase) = splice @args, 0, 3;
  ($phrase, $direction, $lang) = splice @args, 0, 3
      unless defined $direction;

  $lang = $lang_code{$lang};

  my $ua = new LWP::UserAgent;
  $ua->timeout(4);

  my $req =  HTTP::Request->new
      ('POST',
       'http://babelfish.altavista.digital.com/cgi-bin/translate');
  $req->content_type('application/x-www-form-urlencoded');

  my $tolang = "en_$lang";
  my $toenglish = "${lang}_en";

  if ($direction eq 'to' or $direction eq 'in') {
    return translate($phrase, $tolang, $req, $ua);
  }
  elsif ($direction eq 'from') {
    return translate($phrase, $toenglish, $req, $ua);
  }

  my $last_english = $phrase;
  my $last_lang;
  my %results = ();
  my $i = 0;
  while ($i++ < 7) {
    last if $results{$phrase}++;
    $last_lang = $phrase = translate($phrase, $tolang, $req, $ua);
    last if $results{$phrase}++;
    $last_english = $phrase = translate($phrase, $toenglish, $req, $ua);
  }
  return $last_english;
}


sub translate {
  my ($phrase, $languagepair, $req, $ua) = @_;

  my $urltext = uri_escape($phrase);
  $req->content("urltext=$urltext&lp=$languagepair&doit=done");

  my $res = $ua->request($req);

  if ($res->is_success) {
    my $html = $res->content;
    # This method subject to change with the whims of Altavista's design
    # staff.
    my ($translated) = 
	($html =~ m{<br>
			\s+
			    <font\ face="arial,\ helvetica">
				\s*
				    (?:\*\*\s+time\ out\s+\*\*)?
					\s*
					    ([^<]*)
					      }sx);
    $translated =~ s/\n/ /g;
    $translated =~ s/\s*$//;
    return $translated;
  } else {
    return ":(";		# failure 
  }
}

'a true value';
