
package Geckobot::Message;

$VERSION = "0.01_00";
use strict;

sub Geckobot::Message::new {
  my ($class, %params) = @_;

  my $self = \%params;

# viz., connection, protocol, network, server, port, 
#       sender, recipient, text, type, session, bot
#       readwrite, time

  $self->{time} ||= time(),

  bless $self, (ref($class) or $class);   
  return $self;
}

sub Geckobot::Message::protocol {
  my ($self, $arg) = shift @_;
  if ($arg) {
    $self->{protocol} = $arg;
  }
  $self->{protocol};
}

sub Geckobot::Message::sender {
  my ($self, $arg) = shift @_;
  if ($arg) {
    $self->{sender} = $arg;
  }
  $self->{sender};
}

sub Geckobot::Message::recipient {
  my ($self, $arg) = shift @_;
  if ($arg) {
    $self->{recipient} = $arg;
  }
  $self->{recipient};
}

sub Geckobot::Message::text {
  my ($self, $arg) = @_;
  if ($arg) {
    $self->{text} = $arg;
    $self->{orig_text} = $arg if not defined $self->{orig_text};
  }
  $self->{text};
}

sub Geckobot::Message::type {
  my ($self, $arg) = @_;
  if ($arg) {
    $self->{type} = $arg;
  }
  $self->{type};
}

sub Geckobot::Message::time {
  my ($self, $arg) = @_;
  if ($arg) {
    $self->{'time'} = $arg;
  }
  $self->{'time'};
}

sub Geckobot::Message::dump {
  my $self = shift;
  foreach (keys %$self) {
    print "$_ => $self->{$_}\n";
  }
}


1;

