#!/usr/bin/perl -w

package Geckobot::Client;
use Geckobot::Message;
use FileHandle;

sub Geckobot::Client::new {
  my $class = shift;
  my $protocol = shift;
  my $handle = shift; 

  my $self = {};
  $self->{handle} = $handle;
  $self->{protocol} = $protocol;

  bless $self, $class;
}

sub Geckobot::Client::pop {
  my $self = shift ;

  my $fh = $self->{handle};
  my $oldfh = select($fh);
  my ($rin, $rout, $win, $wout, $ein, $eout, $input);

  $rin = '';
  vec($rin, fileno($fh), 1) = 1;

  my $nfound = select($rin, undef, undef, 1);
  select($oldfh);

  if ($nfound) {
      $input = <$fh>;
  } else {
      return undef;
  }

  if (defined $input) {
    my $message = new Geckobot::Message
      (
       sender => { name => 'User' },
       protocol => "tty",
       recipient => "CONSOLE",
       text => $input,
       type => 'private',
      );
    return $message;
  } else {
    return undef;
  }
}

1;
