(* Lang compiler
 * Parsing
 * Author: Kaustuv Chaudhuri <kaustuv+@cs.cmu.edu>
 *)

signature PARSE =
  sig
    val parse : string -> Lang.exp
  end

structure Parse :> PARSE =
  struct 

    structure LangLrVals = LangLrValsFn (structure Token = LrParser.Token)
    structure Lex = LangLexFn (structure Tokens = LangLrVals.Tokens)
    structure LangP = Join (structure ParserData = LangLrVals.ParserData
                           structure Lex = Lex
                           structure LrParser = LrParser)

  (* The main parsing routine *)
  fun parse filename =
    let val _ = (ErrorMsg.reset(); ParseState.reset ())
	val file = TextIO.openIn filename
        val _ = ParseState.setfile filename
	fun get _ = TextIO.input file
        val anyerrors = ref false
	fun parseerror(s,p1,p2) = ErrorMsg.error (ParseState.ext (p1,p2)) s
	val lexer = LrParser.Stream.streamify (Lex.makeLexer get)
	val (absyn, _) = LangP.parse(30,lexer, parseerror, ())
    in
      TextIO.closeIn file; 
      absyn
    end
      handle LrParser.ParseError => raise ErrorMsg.Error
           | e as IO.Io _ => (ErrorMsg.error NONE (exnMessage e);
                              raise ErrorMsg.Error)
end
