signature MARK =
  sig
    type ext = (int * int) * (int * int) * string
    val show : ext -> string

    type 'a marked

    val mark : 'a * ext -> 'a marked
    val mark' : 'a * ext option -> 'a marked
    val naked : 'a -> 'a marked

    val ext : 'a marked -> ext option
    val wrap : ext option list -> ext option

    val data : 'a marked -> 'a

    val map : ('a -> 'b) -> 'a marked -> 'b marked
    val map' : ('a marked -> 'b) -> 'a marked -> 'b marked
  end
  
structure Mark :> MARK =
  struct
    type ext = (int * int) * (int * int) * string

    fun pos (row, 0) = Int.toString row
      | pos (row, col) = Int.toString row ^ "." ^ Int.toString col

    fun show (l, r, file) = file ^ ":" ^ pos l ^ "-" ^ pos r

    type 'a marked = 'a * ext option

    fun mark (d, e) = (d, SOME e)
    fun mark' (d, e) = (d, e)
    fun naked d = (d, NONE)

    fun ext (d, e) = e

    fun extmin ((l1, c1), (l2, c2)) =
          if l1 < l2 then (l1, c1)
          else
            if l1 > l2 then (l2, c2)
            else (l1, Int.min (c1, c2))
    fun extmax ((l1, c1), (l2, c2)) =
          if l1 > l2 then (l1, c1)
          else
            if l1 > l2 then (l2, c2)
            else (l1, Int.min (c1, c2))

    fun wrap [] = NONE
      | wrap (e :: el) =
        (case wrap el of
           NONE => NONE
         | SOME (el1, el2, elf) =>
             (case e of
                SOME (e1, e2, ef) =>
                  if String.compare (ef, elf) = EQUAL then
                    SOME (extmin (e1, el1), extmax (e2, el2), ef)
                  else NONE
              | NONE => SOME (el1, el2, elf)))

    fun data (d, e) = d

    fun map f (d, e) = (f d, e)
    fun map' f (m as (d, e)) = (f m, e)
  end
