structure Lang =
struct

type ident = string

  datatype exp = ExNum of int
               | ExAdd of exp * exp
               | ExTimes of exp * exp
               | ExSub of exp * exp
               | ExDiv of exp * exp
               
 (* printing functions *)
  
      fun expToString (ExNum n) 	= "num(" ^ (Int.toString n) ^ ")"
      | expToString (ExAdd(e1, e2)) = "add("^(expToString e1)^","^(expToString e2)^")"
      | expToString (ExTimes(e1, e2)) = "times("^(expToString e1)^","^(expToString e2)^")"
      | expToString (ExSub(e1, e2)) = "sub("^(expToString e1)^","^(expToString e2)^")"
      | expToString (ExDiv(e1, e2)) = "div("^(expToString e1)^","^(expToString e2)^")"
end
