signature LANG =
sig

  type ident = string

   datatype ty = TyNat
                | TyList
                | TyArrow of ty * ty


  datatype exp = ExVar of ident
               | ExNum of int
               | ExAdd of exp * exp
               | ExFun of ident * ty * exp
               | ExApp of exp * exp
               | ExNil
               | ExCons of exp * exp
               | ExListRec of exp * exp * (ident * ident * ident * exp)

  (* creates a fresh identifier *)
  val newIdent : unit -> ident

  (* printing functions *)
  val tyToString : ty -> string
  val expToString : exp -> string

  (* freshen y for x in e *)
  val freshen : ident -> ident -> exp -> exp

  (* substitutes e' for x in e *)
  val subst : exp -> ident -> exp -> exp
end
