structure L = Lang

type pos = int
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult = (svalue,pos) Tokens.token

val ord0 = Char.ord(#"0")
fun charVal (c) = Char.ord(c)-ord0

local
  val commentLevel = ref 0
  val commentPos = ref 0
  val linCom = ref false
in
  fun enterComment yypos = (commentLevel := !commentLevel + 1; commentPos := yypos)

  fun exitComment () =
      let
        val _ = commentLevel := !commentLevel - 1
      in
        !commentLevel = 0
      end

  fun eof () = 
      let
        val yypos = ParseState.curline ()
      in
        if (!commentLevel > 0) then
          (ErrorMsg.error (ParseState.ext (!commentPos,!commentPos)) "Unterminated comment")
        else ();
        Tokens.EOF (yypos,yypos)
      end
end

%%

%header (functor LangLexFn (structure Tokens : Lang_TOKENS));
%full

%s COMMENT;

id = [A-Za-z_][A-Za-z0-9_]*;
decnum = [0-9]+;

ws = [\ \t\012];

%%

\n                 	=> (ParseState.newline yypos; continue ());

<INITIAL>	{ws}+    => (lex());

<INITIAL> "("         	=> (Tokens.LPAREN (yypos, yypos + size yytext));
<INITIAL> ")"         	=> (Tokens.RPAREN (yypos, yypos + size yytext));

<INITIAL> "+"         	=> (Tokens.ADD (yypos, yypos + size yytext));
<INITIAL> "-"         	=> (Tokens.SUB (yypos, yypos + size yytext));
<INITIAL> "*"         	=> (Tokens.TIMES (yypos, yypos + size yytext));
<INITIAL> "/"         	=> (Tokens.DIV (yypos, yypos + size yytext));

<INITIAL> {decnum}      => (Tokens.NUM ((foldl (fn(c,n)=>10*n + charVal(c)) 0 (explode yytext)), yypos, yypos + size yytext));

<INITIAL> "(*"     	=> (YYBEGIN COMMENT; enterComment yypos; continue ());
<INITIAL> "*)"    	 => (ErrorMsg.error (ParseState.ext (yypos, yypos)) "Unbalanced comments"; continue ());
<COMMENT> "(*"        	=> (enterComment yypos; continue());
<COMMENT> "*)"        	=> (if exitComment () then YYBEGIN INITIAL else (); continue());
<COMMENT> .           	=> (continue());

<INITIAL> .           	=> (ErrorMsg.error (ParseState.ext (yypos,yypos)) ("illegal character: \"" ^ yytext ^ "\"");continue ());

