(* SIMPLE Compiler
 * Error messages
 * Author: Kaustuv Chaudhuri <kaustuv+@cs.cmu.edu>
 *)

signature ERRORMSG =
  sig
    val reset : unit -> unit
      
    val anyErrors : bool ref
      
    val sourceStream : TextIO.instream ref
      
    val error : Mark.ext option -> string -> unit
    val warn : Mark.ext option -> string -> unit
      
    exception Error
    val impossible : string -> 'a
  end

structure ErrorMsg :> ERRORMSG =
  struct
    (* Initial values of compiler state variables *)
    val anyErrors = ref false
    val sourceStream = ref TextIO.stdIn

    fun reset() = (anyErrors:=false; sourceStream:=TextIO.stdIn)

    fun s2dig n = String.concat [if n < 0 then "-" else "",
                                 Int.toString (Int.abs n)]
      
    fun msg str ext note =
          (anyErrors := true;
           Option.map ((fn str => TextIO.output(TextIO.stdErr,str))
		       o Mark.show) ext;
           List.app (fn str => TextIO.output(TextIO.stdErr,str)) [":", str, ":", note, "\n"];
	   TextIO.flushOut TextIO.stdErr
	  )

    val error = msg "error"
    val warn = msg "warning"

    (* Print the given error message and then abort compilation *)
    exception Error
    fun impossible msg =
      (app (fn str => TextIO.output(TextIO.stdErr,str)) ["error: Compiler bug: ", msg, "\n"];
       TextIO.flushOut TextIO.stdErr;
       raise Error)
  end
