import numpy as np
import copy
import math

def NB_XGivenY(XTrain, yTrain):
    """
    Arguments:
        - XTrain: (n, V) array of training documents, where XTrain[i, j] = 1 
            if the i-th document contains word j, 0 otherwise
        - yTrain: (n, 1) array of labels corresponding to each training document

    Returns:
        - D: (2, V) array of MAP estimates, 
            where D[y, w-1] is the MAP estimate of P(X_w = 1 | Y = y), label 0 = false, 1 = true
            filter based on Y, count X_w = 1/feature appear --> MLE
    """
    # Your code here
    raise NotImplementedError


def NB_YPrior(yTrain):
    """
    Arguments:
        - yTrain: (n, 1) array of labels corresponding to each training document

    Returns:
        - p: the MLE for P(Y = 0)
    """

    # Your code here
    raise NotImplementedError


def NB_Classify(D, p, X):
    """
    Arguments:
        - D: (2, V) array of MAP estimates, 
            where D[y, w-1] is the MAP estimate of P(X_w = 1 | Y = y)
        - p: the MLE for P(Y = 0)
        - X: (m, V) array of documents, where X[i, j] = 1 
            if the i-th document contains word j, 0 otherwise

    Returns:
        - yHat: (m, 1) array of predicted labels for each document
    """
    # Your code here
    raise NotImplementedError


def ClassificationError(yHat, yTruth):
    """
    Arguments:
        - yHat: (m, 1) array of predicted labels for each document
        - yTruth: (m, 1) array of ground truth labels for each document
    """
    # Your code here
    raise NotImplementedError


if __name__ == '__main__':
    import pickle
    with open('hw2data.pkl', 'rb') as f:
        data = pickle.load(f)

    XTrain, yTrain = data['XTrain'], data['yTrain']
    XTest, yTest = data['XTest'], data['yTest']

    # You may want to convert XTrain / XTest from a sparse matrix to a dense matrix
    # XTrain, XTest = XTrain.todense(), XTest.todense()

    # Test your code here
