function MAP = lbp(nodep,scale,adj_mat)
% nodep = node potential func
% edgep = edge potential func
% K = number of segments
% adj_mat = adjacency matrix
% scale = beta factor in Potts model

%K = 2;
K = size(nodep,1);
%N = prod(size(img)); % number of nodes
N = size(nodep,2);
schedule = 1:N;
OldMessage = ones([N N K]); % array(node,node,cluster)
NewMessage = ones([N N K]); % array(node,node,cluster)

for i = 1:N
    for k = 1:K
      OldMessage(i,i,k) = nodep(k,i);
      NewMessage(i,i,k) = nodep(k,i);
    end
end

Psi = zeros([K K]);
for vxi = 1:K % values of xi
    for vxj = 1:K % values of xj
        Psi(vxi,vxj) = edgep(vxi,vxj,scale);
    end
end
Psi = Psi';

Iteration = 1;
MaxIterations = 100;
threshold = 10^-5;
eps = threshold + 1;
progressbar = waitbar(0.0,sprintf('Iteration %d',Iteration));
while Iteration < MaxIterations && eps > threshold
    progress = 0;
    waitbar(0.0,progressbar,sprintf('Iteration %d',Iteration));
    for i = schedule
        progress = progress + 1/length(schedule);
        waitbar(progress,progressbar);
        %neighbourhood = neighbours(img,i);
        neighbourhood = find(adj_mat(i,:));
        for j = neighbourhood        
            k = setdiff([neighbourhood i],j);
            combinedMessage = reshape(exp(sum(log(OldMessage(k,i,:)),1)),1,K);
            %fprintf(1,'Neighbours = [%d]\n',k);
            %fprintf(1,'Combined message: %d %d\n',combinedMessage);
            maxMessage = max(Psi .* repmat(combinedMessage,size(Psi,1),1),[],2);
            NewMessage(i,j,:) = maxMessage./sum(maxMessage);
            pause(0);
        end
    end
    eps = max(max(max(abs(NewMessage-OldMessage))));
    meps = mean(mean(mean(abs(NewMessage-OldMessage))));
    fprintf(1,'epsilon = %f (mean-eps = %f)\n',eps,meps);
    OldMessage = NewMessage;
    Iteration = Iteration + 1;
    pause(0);
end
close(progressbar);

% Compute the posterior marginals
Beliefs = zeros([N K]);
for i = 1:N
    %k = [neighbours(img,i) i];
    k = [find(adj_mat(i,:)) i];
    Belief(i,:) = reshape(prod(OldMessage(k,i,:),1),1,K);
    Belief(i,:) = Belief(i,:) ./ sum(Belief(i,:)); 
    %fprintf(1,'Belief(%d) = (%f %f)\n',i,Belief(i,:));
end

% $$$ % Segmentation
% $$$ segmentation = zeros(size(img));
% $$$ for i = 1:N
% $$$     [val,segmentation(i)] = max(Belief(i,:));
% $$$ end

[val,MAP] = max(Belief,[],2);