function f = table_factor(vars, table)
% TABLE_FACTOR    Creates a new table factor
%
%    FACTOR = TABLE_FACTOR(VARS, TABLE) creates a new factor over
%    variables VARS whose table is TABLE.  VARS is a row vector of
%    numbers.  TABLE is an n-dimensional array, where i-th dimension
%    corresponds to i-th entry in VARS.
%
%    FACTOR = TABLE_FACTOR creates a unit factor over an empty set
%    of variables, i.e., a factor equivalent to 1.
%

if nargin==0

  f.vars  = [];
  f.table = 1;

else

  if ~isvector(vars)
    error('VARS needs to be a vector');
  end
  
  if size(vars,1)~=1
    error('VARS needs to be a row vector');
  end
  
  if length(unique(vars))~=length(vars)
    error('The variables in VARS are not unique');
  end
  
  %if (max(length(vars),2)~=ndims(table)) || ...
  %   (isscalar(vars) && size(table,2)>1)
  %  error('Invalid table dimensions.');
  %end
  
  f.vars  = vars;
  f.table = table;

end
