% Script to generate corrAL dataset. Read John and Kohavi, ICML '94 for more details.

% generate X1 - X6
data = dec2bin([0:(2^6-1)]');
data = mat2cell(data,ones(size(data,1),1),ones(size(data,2),1));
data = str2double(data);

% get class variable via boolean function
class = (data(:,1) | data(:,2)) & (data(:,3) | data(:,4));

% append class at the end 
data = [data double(class)];

% change X6 to be 75% correlated with class
rand_list = randperm(size(data,1));
cut_off = ceil(0.75*size(data,1));

agree_list = rand_list(1:cut_off);
data(agree_list,6) = data(agree_list,7);

disagree_list = rand_list((cut_off+1):end);
data(disagree_list,6) = 1-data(disagree_list,7);