function a=assignment(vars, vals)
% ASSIGNMENT     constructs an assignment
%  
%   ASSIGNMENT(VARS,VALS) returns a structre representin an assignment
%   in which VARS(i)=VALS(i) for all i
%
%   VARS, VALS must be row vectors of the same size
%

if ~isvector(vars) || size(vars, 1)>1
  error('VARS must be a row vector of variable IDs.');
end

if ~isvector(vals) || size(vals, 1)>1
  error('VALS must be a row vector of values.');
end

if length(vals)~=length(vars)
  error('VARS and VALS must be row vectors of the same size.');
end

a.vars=vars;
a.vals=vals;
