(* translation from (type-reconstructed) implict to explicit syntax *)
(* could be tricky to convert to Elf... *)

type var = string
local val n = ref 0 
in fun gensym () = (n := !n+1; "x" ^ makestring (!n)) end

datatype tm = VAR of var | APP of tm * tm | LAM of var * tm
  | BOX of tm | UNBOX of tm | POP of tm

datatype etm = EVAR of var | EAPP of etm * etm | ELAM of var * etm
  | EBOX of btm | EUNBOX of etm
and btm = IN of etm | PROMOTE of var * etm * btm

datatype zz = P of etm | Q of (btm -> zz) -> zz

(* itrans : tm -> (etm -> zz) -> zz *)
fun itrans (VAR x) k = k (EVAR x)
  | itrans (APP (e1,e2)) k =
      itrans e1 (fn v1=>itrans e2 (fn v2=>k (EAPP (v1,v2))))
  | itrans (LAM (x,e)) k = itrans e (fn v=>k (ELAM (x,v)))
  | itrans (BOX e) k = 
      let val Q t = itrans e (fn a=>Q (fn m=>m (IN a)))
      in t (fn r=>k (EBOX r)) end
  | itrans (UNBOX e) k = itrans e (fn v=>k (EUNBOX v))
  | itrans (POP e) k = 
      let val x = gensym ()
          val Q t = k (EVAR x) (* note: not parametric \k. ...! *)
      in Q (fn m => itrans e (fn a=>t (fn r=>m (PROMOTE (x, a, r))))) end

fun dotrans e = let val P v = itrans e P in v end

(* examples:

Compiler.Control.Print.printDepth := 100;

(* \x:#(A->B).box (\y:A.(unbox x) y) *)
dotrans (LAM ("x", BOX (LAM ("y", APP (UNBOX (POP (VAR "x")), VAR "y")))));

(* \x:#(A->B).box (\y:A.box ((unbox x) y)) *)
dotrans (LAM ("x", BOX (LAM ("y", BOX (APP (UNBOX (POP (POP (VAR "x"))), POP (VAR "y")))))));

*)
