(* Direct embeddings *)
(* Proof checking is ML type checking *)
local
  open ND0a
in
  (* (A => B => C) => (A & B => C) *)
  fun t1 () : (('a, ('b, 'c) Implies) Implies,
	       (('a, 'b) And, 'c) Implies) Implies
    = Lam (fn u => Lam (fn w => App (App (u, Fst w), Snd w)))
end;

local
  open ND0
in
  (* (A => B => C) => (A & B => C) *)
  fun t1 () = Lam (fn u => Lam (fn w => App (App (u, Fst w), Snd w)))
end;

(* More flexible implementations *)

val A = P.Atom("A");
val B = P.Atom("B");
val C = P.Atom("C");

(* Bottom-up type-checker *)

local
  open P
  open ND1
in

  fun check1 (M, A) =
      (check (C.Null, M, A); print ("OK\n"))
      handle Invalid (msg) => print ("ERROR:" ^ msg ^ "\n")

  val u = ND1.Var("u")
  val w = ND1.Var("w")

  (* (A => B => C) => (A & B => C) *)
  val _ = check1 (Lam (("u", Implies(A, Implies (B, C))),
		       Lam (("w", And (A, B)),
			    (App (App (u, Fst w), Snd w)))),
		  Implies (Implies (A, Implies (B, C)),
			   Implies (And (A, B), C)))

end;

(* Bi-directional type-checker *)

local
  open P
  open ND2
in

  fun check2 (M, A) =
      (check (C.Null, M, A); print ("OK\n"))
      handle Invalid (msg) => print ("ERROR:" ^ msg ^ "\n")

  val u = Var("u")
  val w = Var("w")

  (* (A => B => C) => (A & B => C) *)
  val _ = check2 (Lam ("u", Lam ("w", Elim (App (App (u, Elim (Fst w)),
						 Elim (Snd w))))),
		  Implies (Implies (A, Implies (B, C)),
			   Implies (And (A, B), C)))
end;
