(* Propositions *)
(* Author: Frank Pfenning *)
(* Negation is treated as an abbreviation *)

signature PROP =
sig

  (* Propositions *)
  datatype Prop =                       (* A ::=         *)
    Atom of string                      (*      P        *)
  | And of Prop * Prop                  (*    | A1 & A2  *)
  | True                                (*    | t        *)
  | Implies of Prop * Prop              (*    | A1 -> A2 *)
  | Or of Prop * Prop                   (*    | A1 v A2  *)
  | False                               (*    | f        *)

  val Not : Prop -> Prop                (* ~ A = A => f  *)

  (* eq (A, B) = true  iff  A = B as propositions *)
  val eq : Prop * Prop -> bool

end;  (* signature PROP *)

structure Prop :> PROP =
struct

  (* Propositions *)
  datatype Prop =                       (* A ::=         *)
    Atom of string                      (*      P        *)
  | And of Prop * Prop                  (*    | A1 & A2  *)
  | True                                (*    | t        *)
  | Implies of Prop * Prop              (*    | A1 -> A2 *)
  | Or of Prop * Prop                   (*    | A1 v A2  *)
  | False                               (*    | f        *)

  (* ~ A = A => f *)
  fun Not (A) = Implies (A, False)

  (* eq (A, B) = true  iff  A = B as propositions *)
  (* Could use built-in equality *)
  fun eq (Atom(p), Atom(q)) = (p = q)
    | eq (And(A1, A2), And(B1, B2)) = eq (A1, B1) andalso eq (A2, B2)
    | eq (True, True) = true
    | eq (Implies(A1, A2), Implies(B1, B2)) =
        eq (A1, B1) andalso eq (A2, B2)
    | eq (Or(A1, A2), Or(B1, B2)) =
        eq (A1, B1) andalso eq (A2, B2)
    | eq (False, False) = true
    | eq _ = false

end;  (* structure Prop *)

(* Global abbreviation: P = Prop *)
structure P = Prop;  
