(* Natural Deduction *)
(* Version 0: Direct embedding in ML *)
(* Proof checking is ML type checking *)
(* Note that ML permits too many functions because of recursion
   and effects, so in addition to type-checking we have to
   verify by hand the the functional arguments to "Lam" and "Case"
   are pure
*)
(* Author: Frank Pfenning *)

signature ND0 =
sig

  type ('a, 'b) And
  type True
  type ('a, 'b) Implies
  type ('a, 'b) Or
  type False

  val Pair : 'a * 'b -> ('a, 'b) And
  val Fst : ('a, 'b) And -> 'a
  val Snd : ('a, 'b) And -> 'b
  val Unit : True
  val Lam : ('a -> 'b) -> ('a, 'b) Implies
  val App : ('a, 'b) Implies * 'a -> 'b
  val Inl : 'a -> ('a, 'b) Or
  val Inr : 'b -> ('a, 'b) Or
  val Case : ('a, 'b) Or * ('a -> 'c) * ('b -> 'c) -> 'c
  val Abort : False -> 'a

end;

structure ND0a :> ND0 =
struct

  type ('a, 'b) And = 'a * 'b
  type True = unit
  type ('a, 'b) Implies = 'a -> 'b
  datatype ('a, 'b) Or = inl of 'a | inr of 'b
  type False = unit  (* correct because of opaque ascription *)
  exception Impossible

  fun Pair (M1, M2) = (M1, M2)
  fun Fst (M1, M2) = M1
  fun Snd (M1, M2) = M2
  val Unit = ()
  fun Lam M = M
  fun App (M1, M2) = M1 M2
  fun Inl (M) = inl M
  fun Inr (M) = inr M
  fun Case (inl (M), N1, N2) = N1 M
    | Case (inr (M), N1, N2) = N2 M
  fun Abort () = raise Impossible

end;  (* structure ND0a *)

structure ND0 :> ND0 =
struct

  datatype ('a, 'b) And = Pair of 'a * 'b
  fun Fst (Pair (M1, M2)) = M1
  fun Snd (Pair (M1, M2)) = M2

  datatype True = Unit

  datatype ('a, 'b) Implies = Lam of ('a -> 'b)
  fun App (Lam (M1), M2) = M1 M2

  datatype ('a, 'b) Or =
      Inl of 'a 
    | Inr of 'b

  fun Case (Inl (M), N1, N2) = N1 M
    | Case (Inr (M), N1, N2) = N2 M

  (* Even internally now type is empty *)
  structure Void :> sig type t end =
  struct
    type t = unit
  end
  exception Impossible

  type False = Void.t
  fun Abort (M:False) = raise Impossible

end;  (* structure ND0 *)
