(* Contexts *)
(* Author: Frank Pfenning *)
(*
   Variables (represented by name) are mapped to
   arbitrary values (normally propositions)
*)

signature CTX =
sig

  (* Contexts *)
  (* Later declarations shadow earlier ones *)
  datatype 'a Ctx =			(* G ::=       *)
    Null				(*      .      *)
  | Decl of 'a Ctx * (string * 'a)	(*    | G, x:A *)

  val lookup : 'a Ctx * string -> 'a option

end;  (* signature CTX *)

structure Ctx :> CTX =
struct

  (* Contexts *)
  (* Later declarations shadow earlier ones *)
  datatype 'a Ctx =			(* G ::=       *)
    Null				(*      .      *)
  | Decl of 'a Ctx * (string * 'a)	(*    | G, x:A *)

  (* lookup (G, x) = NONE if x not declared in G
                   = SOME(A) if x:A is last declaration of x in G
  *)
  fun lookup (Null, x) = NONE
    | lookup (Decl (G, (y, A)), x) =
      if (x = y) then SOME(A)
      else lookup (G, x)

end;  (* structure Ctx *)

(* Global abbreviation *)
structure C = Ctx;
