signature TERM =
sig

  structure Ctx : CTX

  type const = string			(* Constants c,f  *)
  type parm = string			(* Parameters a   *)
  type var = string			(* Variables x    *)

					(* Terms          *)
  datatype term =			(* t ::=          *)
    Parm of parm			(*   a            *)
  | Var of var				(* | x            *)
  | Root of const * term list		(* | f(t1,...,tn) *)
  | EVar of parm Ctx.ctx * (term option) ref (* | X^P     *)

  (* subst (t,x) s ===> [t/x] s,  t closed *)
  val subst : (term * var) -> term -> term

  (* eq (t, s) ===> true  iff  t = s, t and s closed *)
  (* eq' (ts, ss) ===> true  iff  ts = ss, ts and ss closed *)
  val eq : term * term -> bool
  and eq' : term list * term list -> bool

  (* closed P t ===> true  iff t closed wrt P *)
  val closed : parm Ctx.ctx -> term -> bool

  (* legal a ===> true  iff a is a legal external parameter *)
  (* External parameters are not allows to start with a digit. *)
  val legal : parm -> bool

  (* newParm () ===> a,  where a is a new internal parameter *)
  (* Internal parameters are natural numbers. *)
  val newParm : unit -> parm

  val newEVar : parm Ctx.ctx -> term
  val trail : ('a -> 'b) -> ('a -> 'b)	(* undo instantiations if exception *)

  exception Unify of string
  val unify : term * term -> unit	(* may raise Unify(msg) *)
  val unify' : term list * term list -> unit (* may raise Unify(msg) *)

  val parmsToString : parm Ctx.ctx -> string
  val toString : term -> string

end;  (* signature TERM *)
