/* combine array elements with addition */
void combine(int* data, int n, int* dest) {
  int i;
  int r = 0;
  for (i = 0; i < n; i++)
    r = r + data[i];
  *dest = r;
}

/* combine array elements with multiplication */
/* step through array by 2 in order to remove some */
/* data dependencies and pipeline two multiplications */
void combine_step2(int* data, int n, int* dest) {
  int i;
  /* two accumulators */
  int r0 = 1;			/* even elements */
  int r1 = 1;			/* odd elements */
  int limit = n-1;		/* new limit for stepping by 2 */
  for (i = 0; i < limit; i += 2) {
    r0 = r0 * data[i];
    r1 = r1 * data[i+1];
  }
  /* multiplying in possibly remaining elements (here at most one) */
  for ( ; i < n; i++)
    r0 = r0 * data[i];
  *dest = r0 * r1;
}
