function [preds, classLogJoints] = predictPMM(X, theta, alpha)
% X is an nxV matrix. theta, alpha are the learned parameters.
% preds (nx1) is the predictions for X
% post (nxK) is the posterior for each class

  % prelims
  n = size(X, 1);
  V = size(X, 2);
  K = numel(theta);

  % First obtain the class log likelihoods
  classLogLs = zeros(n, K);
  for k = 1:K
    classLogLs(:, k) = classLogLikelihoods(X, alpha(k, :));
  end
  % Add the prior to obtain the joint
  classLogJoints = bsxfun(@plus, classLogLs, log(theta'));

  % Finally obtain the predictions
  [~, preds] = max(classLogJoints, [], 2);

end

