function logL = classLogLikelihoods(X, alphak)
% X is an nxV matrix, alphak is the class Dirichlet parameter. logL is a nx1
% vector with the log likelihood of each point

  % Prelims
  Ak = sum(alphak);
  V = size(X, 2); % size of vocabulary
  n = size(X, 1); % number of training data in this class
  m = sum(X, 2); % number of words in each documents
  XplusAlpha = bsxfun(@plus, X, alphak);

  % Compute the log likelihood 
  logL = gammaln(Ak) - gammaln(m + Ak) + ...
    sum(gammaln(XplusAlpha), 2) - sum( gammaln(alphak) );

end

