% prepare data for q2

toy = false; %true;

K = 3;

if toy
  V = 4;
  alphas{1} = [6.0 1.2 1.1 1.2];
  alphas{2} = [1.2 5.1 1.1 1.2];
  alphas{3} = [1.1 1.1 3.2 4.1];
  theta = [0.34; 0.33; 0.33];
  numTrain = 200;
  numTest = 5;
  fileName = 'data11.mat';
else
  V = 1000;
  alpha0 = ones(V, 1);

  % Now group some of the variables together
  shuffleOrder = randperm(V);
  s1 = 1; e1 = round(0.6 * V);
  s2 = round(0.2*V); e2 = round(0.8*V);
  s3 = round(0.4*V); e3 = round(1*V);
  a{1} = shuffleOrder(s1:e1);
  a{2} = shuffleOrder(s2:e2);
  a{3} = shuffleOrder(s3:e3);

  q = 1; alphas{q} = alpha0 + 0.1 * rand(V, 1);
  alphas{q}(a{q}) = alphas{q}(a{q}) + 2 * rand(numel(a{q}), 1);
  q = 2; alphas{q} = alpha0 + 0.1 * rand(V, 1);
  alphas{q}(a{q}) = alphas{q}(a{q}) + 2 * rand(numel(a{q}), 1);
  q = 3; alphas{q} = alpha0 + 0.1 * rand(V, 1);
  alphas{q}(a{q}) = alphas{q}(a{q}) + 2 * rand(numel(a{q}), 1);

  theta = [0.45;0.3;0.25];

  numTrain = 100000; 
  numTest = 10000;

  fileName = 'data2.mat';
end

fprintf('Generating Data ...');
[XTrain, yTrain] = genPDAData(numTrain, theta, alphas);
[XTest, yTest] = genPDAData(numTest, theta, alphas);
fprintf('Done.\n\n');

save(fileName, 'XTrain', 'yTrain', 'XTest', 'yTest', 'K', 'V');

