function [preds, classLogJoints] = predictPDA(X, theta, alpha)

  % prelims
  n = size(X, 1);
  K = numel(theta);

  % First obtain the class log joint probabilities
  classLogLs = zeros(n, K);
  for k = 1:K
    classLogLs(:, k) = classLogLikelihoods(X, alpha(k, :));
  end
  classLogJoints = bsxfun(@plus, classLogLs, log(theta'));

  % Finally obtain the predictions
  [~, preds] = max(classLogJoints, [], 2);

end

