function logL = classLogLikelihoods(X, alphak)

  % Prelims
  Ak = sum(alphak);
  m = sum(X, 2); % number of words in each documents
  XplusAlpha = bsxfun(@plus, X, alphak);

  % Compute the log likelihood 
  logL = gammaln(Ak) - gammaln(m + Ak) + ...
    sum(gammaln(XplusAlpha), 2) - sum( gammaln(alphak) );

end

