function [ path, maxProb ] = viterbi( prior, P, E, o )
%VITERBI Viterbi algorithm for HMM

S = numel(prior);
T = numel(o);

V = zeros(T,S); % V(t,i) probability of the best state sequence giving o(1:t), ending in state i
Z = zeros(T,S); % best previous state for V(t,i)

V(1,:) = (E(:,o(1)) .* prior)';

for t=1:T-1
    for i=1:S
        [maxprob, maxState] = max( P(:,i) .* V(t,:)' );
        V(t+1,i) = E(i,o(t+1)) * maxprob;
        Z(t+1,i) = maxState;
    end
end

path = zeros(T,1);
[maxProb, path(T)] = max(V(T,:));

for i=1:T-1
    t = T-i;
    path(t) = Z(t+1, path(t+1));
end

end

% To run
% load('params_viterbi.mat')
% [path, maxProb] = viterbi(prior, transition, emission, observations);

