
rng(400);
u = [-4 0; 4 0; 0 7];
K = 3;
cluster_size = 30;
n = K*cluster_size;
x = zeros(n,2);
for i=1:3
    x(((i-1)*cluster_size+1):i*cluster_size,:) = mvnrnd(u(i,:), eye(2), 30);
end

z0 = randsample(3,n,true);
mu0 = mvnrnd(zeros(2,1), eye(2), K);
burnin = 5000;
nsamples = 10;
[samples] = gibbs(x, z0, mu0, burnin, nsamples );

s = samples(2,:);
z = s(1:n);
mu = reshape(s((n+1):(n+2*K)), K, 2);

figure
colors = {'r','b','g'};
for k=1:K
    points_in_cluster = find(z == k);
    xk = x(points_in_cluster,:);
    scatter(xk(:,1), xk(:,2), '+', colors{k});
    hold on
end
hold off
