/*******************************************************************\

Module:

Author: Daniel Kroening, kroening@cs.cmu.edu

\*******************************************************************/

#ifndef CPROVER_TYPECHECK_H
#define CPROVER_TYPECHECK_H

#include <strstream>

#include "expr.h"

class typecheckt
 {
 public:
  typecheckt(std::ostream &_err):err(_err) { }
  virtual ~typecheckt() { }
  
  // main function

  virtual void typecheck()=0;

  virtual bool typecheck_main();

  // overload to use language specific syntax
  
  virtual std::string to_string(const typet &type) { return type.to_string(); };
  virtual std::string to_string(const exprt &expr) { return expr.to_string(); };

 protected:
  std::ostream &err;

  void err_location(const irept &irep);
 };

#endif
